Rkns.Serializers.BasicJson = Rkns.Utils.inherit(Rkns.Serializers._Base);

Rkns.Serializers.BasicJson.prototype._init = function() {
    this.load(this._project._opts.url);
    var _this = this;
    this.save = Rkns._.throttle(function() {
        _this._save.apply(this, Array.prototype.slice.call(arguments,0));
    }, 2000);
}

Rkns.Serializers.BasicJson.prototype.load = function(_url) {
    var _this = this;
    Rkns.$.getJSON(_url, function(_data) {
        _this.deserialize(_data);
        _this.handleCallbacks();
    });
}

Rkns.Serializers.BasicJson.prototype.deserialize = function(_serializedData) {
    if (typeof _serializedData === "string") {
        _serializedData = JSON.parse(_serializedData);
    }
    var _proj = this._project;
    _proj.title = _serializedData.title || "(untitled project)";
    if (typeof _serializedData.users === "object" && _serializedData.users) {
        Rkns._(_serializedData.users).each(function(_data) {
            var _userData = {
                id: _data.id,
                title: _data.title,
                uri: _data.uri,
                color: _data.color
            };
            _proj.addUser(_userData);
        });
    }
    if (typeof _serializedData.nodes === "object" && _serializedData.nodes) {
        Rkns._(_serializedData.nodes).each(function(_data) {
            var _nodeData = {
                id: _data.id,
                title: _data.title,
                uri: _data.uri,
                created_by: _data.created_by,
                position: {
                    x: _data.position.x,
                    y: _data.position.y
                }
            };
            _proj.addNode(_nodeData);
        });
    }
    if (typeof _serializedData.edges === "object" && _serializedData.edges) {
        Rkns._(_serializedData.edges).each(function(_data) {
            var _edgeData = {
                id: _data.id,
                title: _data.title,
                uri: _data.uri,
                from: _data.from,
                to: _data.to,
                created_by: _data.created_by
            };
            _proj.addEdge(_edgeData);
        });
    }
}

Rkns.Serializers.BasicJson.prototype.serialize = function() {
    var _res = {
        title: this._project.title,
        users: this._project.users.map(function(_user) {
            return {
                id: _user.id,
                title: _user.title,
                uri: _user.uri,
                color: _user.color
            }
        }),
        nodes: this._project.nodes.map(function(_node) {
            return {
                id: _node.id,
                title: _node.title,
                uri: _node.uri,
                created_by: _node.created_by.id,
                position: {
                    x: _node.position.x,
                    y: _node.position.y
                }
            }
        }),
        edges: this._project.edges.map(function(_node) {
            return {
                id: _node.id,
                title: _node.title,
                uri: _node.uri,
                from: _node.from.id,
                to: _node.to.id,
                created_by: _node.created_by.id
            }
        })
    }
    return _res;
}

Rkns.Serializers.BasicJson.prototype._save = function() {
    var _data = this.serialize();
    Rkns.$.post(
        this._project._opts.url,
        _data,
        function(_res) {
        }
    );
}
