# Renkan API Documentation

Ce document présente le fonctionnement et les différentes méthodes de l'API Renkan, basée sur DjangoRestFramework

### Objets manipulés et représentation en JSON

##### Renkan

L'objet Renkan est le principal point d'entrée de l'API.    
Chaque Renkan est associé à au plus un workspace et au moins une révision

* Représentation JSON   

```sh
    {
        "id" : id du renkan,
        "title" : titre du renkan,
        "content" : contenu (JSON) du renkan,
        "current_revision_id" : id de la révision courante du 	renkan,
        "source_revision_id" : id de la révision ayant servi à copier le renkan, chaîne vide sinon,
        "workspace_id" : si le renkan est assigné à un workspace, id du workspace du renkan,
        "revision_count": le nombre de révisions du renkan au moment du la requête,
        "created_by" : username du créateur du renkan,
        "last_updated_by" : username du dernier utilisateur à avoir modifié le renkan,
        "creation_date" : date de création du renkan,
        "modification_date" : date de dernière modification du renkan,
    }
```

##### Révisions

Une révision représente l'état d'un renkan à un instant donné.    
Chaque révision est associé à un unique Renkan. Lorsqu'un renkan est modifié, on peut soit altérer la révision courante, soit créer une nouvelle révision. La dernière révision d'un renkan donné créée est la "révision courante" de ce renkan.    

C'est au niveau de l'objet Révision que sont stockées les informations de titre et de contenu d'un Renkan. 

* Représentation JSON   

```sh
    {
    	"id" : id de la revision
    	"title" : titre de la revision
    	"content" : contenu (JSON) de la revision
    	"parent_renkan_id" : id du renkan associé à la révision 
    	"workspace_id" : si le renkan associé à la révision est assigné à un workspace, 
    	id du workspace du renkan,
    	"renkan_created_by" : username du créateur du renkan
    	"renkan_last_updated_by" : username du dernier utilisateur à avoir modifié le renkan
    	"revision_created_by" : username du créateur de la révision
    	"revision_last_updated_by" : username du dernier utilisateur à avoir modifié la révision	
    	"revision_modification_date" :  date de dernière modification de la révision
    }
```

##### Workspaces
Un workspace (ou espace) renkan est une structure (optionnelle) regroupant un ou plusieurs renkans. 

* Représentation JSON   

```sh
   {
    	"id" : id du workspace
    	"title" : titre du workspace
    	"renkan_count": nombre de renkans associés au workspace
    	"revision_created_by" : username du créateur du workspace
    	"creation_date": date de création du workspace
    }
```

### Liste exhaustive des endpoints de l'API

#### Endpoints Renkan
1. **Créer un Renkan**    
```POST /renkan-api/renkans/```

Données à passer en JSON (facultatif):
```
    {
	    "title": titre du renkan à créer (facultatif)
	    "content": JSON du renkan à créer (facultatif)
    }
```

**Note:** Si aucun titre n'est fournie le renkan sera intitulé "Untitled Renkan". Si aucun contenu n'est fourni un JSON minimal sera généré

Si succès: Renvoie ```201 CREATED``` et le json associé au renkan créé

2. **Dupliquer un Renkan**    
```POST /renkan-api/renkans/?source_renkan_id=<:renkan_id>```    

Données à passer en JSON:
```
{
	"title": titre de la copie (facultatif)
}
```    

**Note:** Dans l'implémentation actuelle, si la donnée "title" n'est pas fournie, le titre du renkan copié sera identique au titre du renkan source.

Si succès: renvoie ```201 CREATED``` et le json décrivant le renkan créé.    
Si échec: renvoie un ```404 NOT FOUND``` si ```<:renkan_id>``` ne correspond à aucun renkan existant

3. **Modifier un Renkan**    
```PUT /renkan-api/renkans/<:renkan_id>```

Données à passer en JSON:
```
{
	"title": nouveau titre du renkan
}
```

Si succès: renvoie ```200 OK``` et le json associé au renkan modifié    
Si échec:  renvoie un ```404 NOT FOUND``` si ```<:renkan_id>``` ne correspond à aucun renkan existant.

4. **Obtenir la liste des Renkan**  
```GET /renkan-api/renkans/```

Renvoie la liste des renkans auxquels l'utilisateur authentifié a accès en lecture.

Si succès: Renvoie ```200 OK```et une liste où chaque élément correspond à un json de renkan.

5. **Obtenir les informations sur un Renkan**    
```GET /renkan-api/renkans/<:renkan_id>```    

Si succès: renvoie ```200 OK``` et le json associé au renkan requêté    
Si échec: renvoie ```404 NOT FOUND``` si ```<:renkan_id>``` ne correspond à aucun renkan existant.

6. **Supprimer un renkan**  
```DELETE /renkan-api/renkans/<:renkan_id>```

Si succès: renvoie ```204 NO CONTENT```     
Si échec: renvoie un ```404 NOT FOUND``` si ```<:renkan_id>``` ne correspond à aucun renkan existant.

#### Endpoints Révision
1. **Obtenir la liste des révisions pour un Renkan donné**	
```GET /renkan-api/renkans/<:renkan_id>/revisions/```

Si succès: Renvoie ```200 OK``` et une liste où chaque élément est un json correspondant à une révision.    
Si échec: Renvoie un ```404 NOT FOUND``` si le ```<:renkan_id>``` ne correspond à aucun renkan existant

2. **Obtenir les informations sur une révision**    
```GET /renkan-api/renkans/<:renkan_id>/revisions/<:revision_id>```

Si succès: renvoie ```200 OK``` et le json associé à la révision requêtée     
Si échec: renvoie un ```404 NOT FOUND``` si ```<:renkan_id>``` ne correspond à aucun renkan existant ou que ```<:revision_id>``` ne correspond à aucune révision existante.

3. **Supprimer une révision**   
```DELETE /renkan-api/renkans/<:renkan_id>/revisions/<:revision_id>```

**Note:** il est impossible de supprimer la "révision courante" d'un renkan.

Si succès: renvoie ```204 NO CONTENT```  
Si échec: renvoie un ```404 NOT FOUND``` si ```<:renkan_id>``` ne correspond à aucun renkan existant ou si ```<:revision_id>``` ne correspond à aucune révision existante

#### Endpoints Workspace
1. **Créer un Workspace**   
```POST /renkan-api/workspaces/```

Données à fournir en JSON (facultatif):
``` 
{
    "title": titre du workspace à créer
}
```

Si succès: Renvoie ```201 CREATED``` et le json associé au workspace créé

2. **Créer un Renkan dans un Workspace donné**  
```POST /renkan-api/workspaces/<:workspace_id>/renkans/```

Données (facultatif):
```
{
	"title": titre du renkan à créer (facultatif)
	"content": JSON du renkan à créer (facultatif)
}
```

**Note:** Si aucun titre n'est fournie le renkan sera intitulé "Untitled Renkan". Si aucun contenu n'est fourni un JSON minimal sera généré

Si succès: Renvoie ```201 CREATED``` et le json associé au renkan créé  
Si échec: Renvoie un ```404 NOT FOUND``` si le ```<:workspace_id>``` ne correspond à aucun workspace exis-tant

3. **Obtenir la liste des Workspaces**  
```GET /renkan-api/workspaces/ ```

Si succès: renvoie ```200 OK``` et une liste où chaque élément est un json correspondant à un workspace.

4. **Obtenir la liste des Renkan associé à un Workspace donné**     
```GET /renkan-api/workspace/<:workspace_id>/renkans/```

Renvoie la liste des renkans (associés au workspace) auxquels l'utilisateur authentifié a accès en lecture.

Si succès: Renvoie ```200 OK``` et une liste où chaque élément correspond à un json de renkan.    
Si échec: Renvoie un ```404 NOT FOUND``` si le ```<:workspace_id>``` ne correspond à aucun workspace exis-tant

5. **Obtenir les informations sur un Workspace**    
```GET /renkan-api/workspaces/```

Si succès:renvoie ```200 OK``` et une liste où chaque élément est un json correspondant à un workspace.    
Si échec: renvoie un ```404 NOT FOUND``` si le ```<:workspace_id>``` ne correspond à aucun workspace existant

6. **Supprimer un Workspace**   
```DELETE /renkan-api/workspaces/<:workspace_id>```

Note: il est impossible de supprimer un workspace s'il reste au moins un renkan assigné à celui-ci.

Si succès: renvoie ```204 NO CONTENT```     
Si échec: renvoie un ```404 NOT FOUND``` si le ```<:workspace_id>``` ne correspond à aucun workspace existant 


