Rkns.Wikipedia = {
};

Rkns.Wikipedia.Search = function(_renkan, _opts) {
    this.renkan = _renkan;
    this.lang = _opts.lang || "en";
};

Rkns.Wikipedia.Search.prototype.getBgClass = function() {
    return "Rk-Wikipedia-Search-Icon Rk-Wikipedia-Lang-" + this.lang;
};

Rkns.Wikipedia.Search.prototype.getSearchTitle = function() {
    var langs = {
        "fr": "French",
        "en": "English",
        "ja": "Japanese"
    };
    if (langs[this.lang]) {
        return this.renkan.translate("Wikipedia in ") + this.renkan.translate(langs[this.lang]);
    } else {
        return this.renkan.translate("Wikipedia") + " [" + this.lang + "]";
    }
};

Rkns.Wikipedia.Search.prototype.search = function(_q) {
    this.renkan.tabs.push(
        new Rkns.Wikipedia.Bin(this.renkan, {
            lang: this.lang,
            search: _q
        })
    );
};

Rkns.Wikipedia.Bin = Rkns.Utils.inherit(Rkns._BaseBin);

Rkns.Wikipedia.Bin.prototype._init = function(_renkan, _opts) {
    this.renkan = _renkan;
    this.search = _opts.search;
    this.resultTemplate = _renkan.options.templates['templates/wikipedia-bin/resulttemplate.html'];
    this.lang = _opts.lang || "en";
    this.title_icon_$.addClass('Rk-Wikipedia-Title-Icon Rk-Wikipedia-Lang-' + this.lang);
    this.title_$.html(this.search).addClass("Rk-Wikipedia-Title");
    this.refresh();
};

Rkns.Wikipedia.Bin.prototype.render = function(searchbase) {
    var search = searchbase || Rkns.Utils.regexpFromTextOrArray();
    var highlightrx = (search.isempty ? Rkns.Utils.regexpFromTextOrArray(this.search) : search);
    function highlight(_text) {
        return highlightrx.replace(_(_text).escape(), "<span class='searchmatch'>$1</span>");
    }
    var _html = "",
        _this = this,
        count = 0;
    Rkns._.each(this.data.query.search, function(_result) {
        var title = _result.title,
            url = "http://" + _this.lang + ".wikipedia.org/wiki/" + encodeURI(title.replace(/ /g,"_")),
            description = Rkns.$('<div>').html(_result.snippet).text();
        if (!search.isempty && !search.test(title) && !search.test(description)) {
            return;
        }
        count++;
        _html += _this.resultTemplate({
            url: url,
            title: title,
            htitle: highlight(title),
            description: description,
            hdescription: highlight(description),
            static_url: _this.renkan.options.static_url
        });
    });
    _this.main_$.html(_html);
    if (!search.isempty && count) {
        this.count_$.text(count).show();
    } else {
        this.count_$.hide();
    }
    if (!search.isempty && !count) {
        this.$.hide();
    } else {
        this.$.show();
    }
    this.renkan.resizeBins();
};

Rkns.Wikipedia.Bin.prototype.refresh = function() {
    var _this = this;
    Rkns.$.ajax({
        url: "http://" + _this.lang + ".wikipedia.org/w/api.php?action=query&list=search&srsearch=" + encodeURIComponent(this.search) + "&format=json",
        dataType: "jsonp",
        success: function(_data) {
            _this.data = _data;
            _this.render();
        }
    });
};
