# Renkan - Client configuration

Renkan is a tool to simply build oriented graphs by creating nodes and drag'n'droping links, 
pictures and html elements from web pages. Each node can have title, description, uri/url, color, 
image and specific size. Each node can have title, uri/url and color.


## Embedding Renkan in a web page

Whatever configuration you have, you need to import those javascript files **in that order**...

    <script src="[...]/jquery.min.js"></script>
    <script src="[...]/jquery.mousewheel.min.js"></script>
    <script src="[...]/underscore-min.js"></script>
    <script src="[...]/backbone.js"></script>
    <script src="[...]/backbone-relational.js"></script>
    <script src="[...]/paper.js"></script>
    <script src="[...]/renkan.js"></script>

... and the renkan css file :

    <link rel="stylesheet" href="[...]/renkan.css" />

Finally, add the div in you DOM :

    <div id="renkan"></div>

Your Renkan should be displayed. Now let's see more specifically the 2 displays possibilities : in body 100% or in a div with set width and height.

N.B. : renkan.js is the concatenation of those js files : header.js main.js models.js defaults.js i18n.js paper-renderer.js full-json.js ldtjson-bin.js list-bin.js wikipedia-bin.js. 

### In body 100%

Nothing to add, the html is very simple :

    <body>
        <div id="renkan"></div>
    </body>


### In a div

The renkan div has the css attributes position:absolute/top:0/left:0/bottom:0/right:0, 
so the parent div has to be in position:relative and define width and height. Here is a simple example including css and partial html :

    <head>
      <style type="text/css">
        body{
            margin: 0 auto;
            width: 960px;
        }
        .header, .footer {
            font-size: 14px;
            height: 40px;
            padding-top: 10px;
        }
        .rnk-container{
            height: 500px;
            position: relative;
            width: 700px;
        }
      </style>
    </head>
    <body>
      <div class="header">
        This is a header
      </div>
      <div class="rnk-container">
         <div id="renkan"></div>
      </div>
      <div class="footer">
        This is a footer
      </div>
    </body>


## Embedding a read only Renkan

To embed a read only Renkan, just add this script tag :

    <script type="text/javascript">
        var _renkan;
        $(function() {
            _renkan = new Rkns.Renkan({
                editor_mode: false,
                show_bins: false,
            });
            Rkns.jsonIO(_renkan, {
                url: "any_local_or_jsonp_url"
            });
        });
    </script>



## Embedding a writable Renkan

### Simple mode : no bins on the left, just the canvas

To embed a simple writable Renkan, just add this script tag. In the client folder, "data/simple-persist.php" makes a very simple persistent url. 
The persistent url is supposed to give the json data on GET request at page load, and save datas at PUT request sent by the browser :

    <script type="text/javascript">
        var _renkan;
        $(function() {
            _renkan = new Rkns.Renkan({
                show_bins: false
            });
            Rkns.jsonIO(_renkan, {
                url: "url_of_a_persistent_connection"
            });
        });
    </script>




## Data bins

More to come...





