package org.iri_research.renkan.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import org.iri_research.renkan.Constants;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;

@Document(collection = "users")
public class User extends AbstractRenkanModel<String> implements UserDetails {

    private static final long serialVersionUID = 6972038893086220548L;
    
    
    private String avatar;
    @Field("credentials_expiration_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone = "GMT")
    private Date credentialExpirationDate;
    private String email;
    private boolean enabled;
    @Field("expiration_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone = "GMT")
    private Date expirationDate;
    private boolean locked;
    private String password;
    @Field("authorities")
    private List<String> userAuthorities;

    public User() {
    }

    public User(String id, String title, String description, String uri,
            String color) {
        super(id, title, description, uri, color);
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        boolean hasUserRole = false;
        for (String role : this.getUserAuthorities()) {
            hasUserRole = hasUserRole || Constants.ROLE_USER.equals(role);
            authorities.add(new SimpleGrantedAuthority(role));
        }
        if(!hasUserRole) {
            authorities.add(new SimpleGrantedAuthority(Constants.ROLE_USER));
        }
        
        return authorities;
    }

    public String getAvatar() {
        return avatar;
    }

    public String getColor() {
        return this.color;
    }

    public Date getCredentialExpirationDate() {
        return credentialExpirationDate;
    }

    public String getEmail() {
        return email;
    }

    public Date getExpirationDate() {
        return expirationDate;
    }

    @Override
    @JsonIgnore
    public String getPassword() {
        return this.password;
    }

    @Override
    protected String getRawKeyPart() {
        return "";
    }

    public List<String> getUserAuthorities() {
        return userAuthorities;
    }

    @Override
    @JsonIgnore
    public String getUsername() {
        return this.title;
    }

    @Override
    public boolean isAccountNonExpired() {
        return this.expirationDate == null
                || this.expirationDate.after(new Date());
    }

    @Override
    public boolean isAccountNonLocked() {
        return !this.locked;
    }

    @Override
    public boolean isCredentialsNonExpired() {
        return this.credentialExpirationDate == null
                || this.credentialExpirationDate.after(new Date());
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isLocked() {
        return locked;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public void setCredentialExpirationDate(Date credentialExpirationDate) {
        this.credentialExpirationDate = credentialExpirationDate;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUserAuthorities(List<String> userAuthorities) {
        this.userAuthorities = userAuthorities;
    }

}
