/*
 * Decompiled with CFR 0.152.
 */
package org.coweb;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.coweb.SessionHandler;
import org.coweb.oe.ContextVector;
import org.coweb.oe.Operation;
import org.coweb.oe.OperationEngine;
import org.coweb.oe.OperationEngineException;
import org.eclipse.jetty.util.ajax.JSON;

public class OperationEngineHandler {
    private static final Logger log = Logger.getLogger(OperationEngineHandler.class.getName());
    private OperationEngine engine = null;
    private SessionHandler sessionHandler = null;
    private boolean shouldPurge = false;
    private boolean shouldSync = false;
    private Timer purgeTimer = null;
    private Timer syncTimer = null;
    private PurgeTask purgeTask = null;
    private SyncTask syncTask = null;

    public OperationEngineHandler(SessionHandler sessionHandler, int siteId) throws OperationEngineException {
        this.sessionHandler = sessionHandler;
        this.engine = new OperationEngine(siteId);
        this.engine.freezeSite(0);
        this.purgeTimer = new Timer();
        this.purgeTask = new PurgeTask();
        this.purgeTimer.scheduleAtFixedRate((TimerTask)this.purgeTask, new Date(), 10000L);
        this.syncTimer = new Timer();
        this.syncTask = new SyncTask();
        this.syncTimer.scheduleAtFixedRate((TimerTask)this.syncTask, new Date(), 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localSync(String topic, Object value, String type, int position) {
        String jsonValue = JSON.toString((Object)value);
        ContextVector cv = null;
        Operation op = null;
        if (null != type) {
            try {
                op = this.engine.createOp(true, topic, jsonValue, type, position, -1, null, -1);
                cv = op.getContextVector();
            }
            catch (OperationEngineException e) {
                log.warning("Bad type: " + type + ", using null type instead.");
                type = null;
            }
        }
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("topic", topic);
        message.put("value", jsonValue);
        message.put("type", type);
        message.put("position", position);
        if (null != cv) {
            int[] sites = cv.getSites();
            if (null != sites) {
                Integer[] Sites = new Integer[sites.length];
                for (int i = 0; i < sites.length; ++i) {
                    Sites[i] = sites[i];
                }
                message.put("context", Sites);
            } else {
                message.put("context", null);
            }
        } else {
            message.put("context", null);
        }
        this.sessionHandler.sendModeratorSync(message);
        if (null != type) {
            OperationEngine operationEngine = this.engine;
            synchronized (operationEngine) {
                this.engine.pushLocalOp(op);
            }
        }
    }

    public Map<String, Object> syncInbound(Map<String, Object> data) {
        String topic = (String)data.get("topic");
        String value = null;
        if (data.get("value") instanceof String) {
            value = (String)data.get("value");
        } else {
            Map val = (Map)data.get("value");
            if (val != null) {
                value = JSON.toString((Map)val);
            }
        }
        String type = (String)data.get("type");
        Number pos = (Number)data.get("position");
        int position = 0;
        if (pos != null) {
            position = pos.intValue();
        }
        Number ste = (Number)data.get("siteId");
        int site = 0;
        if (ste != null) {
            site = ste.intValue();
        }
        int[] sites = this.getSites(data);
        Number ord = (Number)data.get("order");
        int order = 0;
        if (ord != null) {
            order = ord.intValue();
        }
        Operation op = null;
        if (sites != null && type != null) {
            try {
                op = this.engine.push(false, topic, value, type, position, site, sites, order);
            }
            catch (OperationEngineException e) {
                e.printStackTrace();
                return null;
            }
            if (op == null) {
                return null;
            }
            value = op.getValue();
            position = op.getPosition();
        } else if (site == this.engine.getSiteId()) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("position", new Integer(position));
        hashMap.put("type", type);
        hashMap.put("value", JSON.parse((String)value));
        hashMap.put("site", site);
        hashMap.put("topic", topic);
        this.shouldPurge = true;
        this.shouldSync = true;
        return hashMap;
    }

    public void engineSyncInbound(Map<String, Object> data) {
        int[] sites = this.getSites(data);
        Integer ste = (Integer)data.get("siteId");
        int site = -1;
        if (ste != null) {
            site = ste;
        }
        if (site == this.engine.getSiteId()) {
            return;
        }
        try {
            this.engine.pushSyncWithSites(site, sites);
        }
        catch (OperationEngineException e) {
            log.info("UnmanagedHubListener: failed to recv engine sync " + site + " " + sites + " " + e.getMessage());
        }
        this.shouldPurge = true;
    }

    private int[] getSites(Map<String, Object> data) {
        int[] sites = null;
        Object[] objArr = (Object[])data.get("context");
        if (objArr != null) {
            sites = new int[objArr.length];
            for (int i = 0; i < objArr.length; ++i) {
                sites[i] = ((Number)objArr[i]).intValue();
            }
        }
        return sites;
    }

    public Object[] getEngineState() {
        return this.engine.getState();
    }

    void shutdown() {
        this.purgeTask.cancel();
        this.syncTask.cancel();
    }

    class SyncTask
    extends TimerTask {
        SyncTask() {
        }

        @Override
        public void run() {
            if (!OperationEngineHandler.this.shouldSync || OperationEngineHandler.this.engine == null) {
                return;
            }
            try {
                ContextVector cv = OperationEngineHandler.this.engine.copyContextVector();
                int cnt = 0;
                int[] sites = cv.getSites();
                Integer[] arr = new Integer[sites.length];
                for (int i : sites) {
                    arr[cnt] = i;
                    ++cnt;
                }
                OperationEngineHandler.this.sessionHandler.postEngineSync(arr);
            }
            catch (OperationEngineException e) {
                e.printStackTrace();
            }
            OperationEngineHandler.this.shouldSync = false;
        }
    }

    class PurgeTask
    extends TimerTask {
        PurgeTask() {
        }

        @Override
        public void run() {
            if (OperationEngineHandler.this.engine == null) {
                return;
            }
            if (OperationEngineHandler.this.shouldPurge) {
                try {
                    OperationEngineHandler.this.engine.purge();
                }
                catch (OperationEngineException e) {
                    e.printStackTrace();
                }
            }
            OperationEngineHandler.this.shouldPurge = false;
        }
    }
}

