
define([], function () {
    'use strict';

    /* ShapeBuilder Begin */

    var builders = {
        "circle":{
            getShape: function() {
                return new paper.Path.Circle([0, 0], 1);
            },
            getImageShape: function(center, radius) {
                return new paper.Path.Circle(center, radius);
            }
        },
        "rectangle":{
            getShape: function() {
                return new paper.Path.Rectangle([-2, -2], [2, 2]);
            },
            getImageShape: function(center, radius) {
                return new paper.Path.Rectangle([-radius, -radius], [radius*2, radius*2]);
            }
        },
        "ellipse":{
            getShape: function() {
                return new paper.Path.Ellipse(new paper.Rectangle([-2, -1], [2, 1]));
            },
            getImageShape: function(center, radius) {
                return new paper.Path.Ellipse(new paper.Rectangle([-radius, -radius/2], [radius*2, radius]));
            }
        },
        "polygon":{
            getShape: function() {
                return new paper.Path.RegularPolygon([0, 0], 6, 1);
            },
            getImageShape: function(center, radius) {
                return new paper.Path.RegularPolygon([0, 0], 6, radius);
            }
        },
        "diamond":{
            getShape: function() {
                var d = new paper.Path.Rectangle([-2, -2], [2, 2]);
                d.rotate(45);
                return d;
            },
            getImageShape: function(center, radius) {
                var d = new paper.Path.Rectangle([-radius, -radius], [radius*2, radius*2]);
                d.rotate(45);
                return d;
            }
        },
        "star":{
            getShape: function() {
                return new paper.Path.Star([0, 0], 8, 1, 0.7);
            },
            getImageShape: function(center, radius) {
                return new paper.Path.Star([0, 0], 8, radius*1, radius*0.7);
            }
        },
    };
    
    var ShapeBuilder = function (shape){
        if(!(shape in builders)){
            shape = "circle";
        }
        return builders[shape];
    };

    return ShapeBuilder;

});
