
define(['jquery', 'underscore', 'requtils', 'renderer/nodebutton'], function ($, _, requtils, NodeButton) {
    'use strict';

    var Utils = requtils.getUtils();

    /* NodeLinkButton Begin */

    //var NodeLinkButton = Renderer.NodeLinkButton = Utils.inherit(Renderer._NodeButton);
    var NodeLinkButton = Utils.inherit(NodeButton);

    _(NodeLinkButton.prototype).extend({
        _init: function() {
            this.type = "Node-link-button";
            this.lastSectorInner = 0;
            this.startAngle = 90;
            this.endAngle = 180;
            this.imageName = "link";
            this.text = "Link to another node";
        },
        mousedown: function(_event, _isTouch) {
            if (this.renderer.isEditable()) {
                var _off = this.renderer.canvas_$.offset(),
                _point = new paper.Point([
                                          _event.pageX - _off.left,
                                          _event.pageY - _off.top
                                          ]);
                this.renderer.click_target = null;
                this.renderer.removeRepresentationsOfType("editor");
                this.renderer.addTempEdge(this.source_representation, _point);
            }
        }
    }).value();
//    });

    /* NodeLinkButton End */

    return NodeLinkButton;

});
