

define(['jquery', 'underscore', 'requtils', 'renderer/baserepresentation'], function ($, _, requtils, BaseRepresentation) {
    'use strict';

    var Utils = requtils.getUtils();

    /* TempEdge Class Begin */

    //var TempEdge = Renderer.TempEdge = Utils.inherit(Renderer._BaseRepresentation);
    var TempEdge = Utils.inherit(BaseRepresentation);

    _(TempEdge.prototype).extend({
        _init: function() {
            this.renderer.edge_layer.activate();
            this.type = "Temp-edge";

            var _color = (this.project.get("users").get(this.renkan.current_user) || Utils._USER_PLACEHOLDER(this.renkan)).get("color");
            this.line = new paper.Path();
            this.line.strokeColor = _color;
            this.line.dashArray = [4, 2];
            this.line.strokeWidth = this.options.selected_edge_stroke_width;
            this.line.add([0,0],[0,0]);
            this.line.__representation = this;
            this.arrow = new paper.Path();
            this.arrow.fillColor = _color;
            this.arrow.add(
                    [ 0, 0 ],
                    [ this.options.edge_arrow_length, this.options.edge_arrow_width / 2 ],
                    [ 0, this.options.edge_arrow_width ]
            );
            this.arrow.__representation = this;
            this.arrow_angle = 0;
        },
        redraw: function() {
            var _p0 = this.from_representation.paper_coords,
            _p1 = this.end_pos,
            _a = _p1.subtract(_p0).angle,
            _c = _p0.add(_p1).divide(2);
            this.line.segments[0].point = _p0;
            this.line.segments[1].point = _p1;
            this.arrow.rotate(_a - this.arrow_angle);
            this.arrow.position = _c;
            this.arrow_angle = _a;
        },
        paperShift: function(_delta) {
            if (!this.renderer.isEditable()) {
                this.renderer.removeRepresentation(_this);
                paper.view.draw();
                return;
            }
            this.end_pos = this.end_pos.add(_delta);
            var _hitResult = paper.project.hitTest(this.end_pos);
            this.renderer.findTarget(_hitResult);
            this.redraw();
        },
        mouseup: function(_event, _isTouch) {
            var _hitResult = paper.project.hitTest(_event.point),
            _model = this.from_representation.model,
            _endDrag = true;
            if (_hitResult && typeof _hitResult.item.__representation !== "undefined") {
                var _target = _hitResult.item.__representation;
                if (_target.type.substr(0,4) === "Node") {
                    var _destmodel = _target.model || _target.source_representation.model;
                    if (_model !== _destmodel) {
                        var _data = {
                                id: Utils.getUID('edge'),
                                created_by: this.renkan.current_user,
                                from: _model,
                                to: _destmodel
                        };
                        if (this.renderer.isEditable()) {
                            this.project.addEdge(_data);
                        }
                    }
                }

                if (_model === _target.model || (_target.source_representation && _target.source_representation.model === _model)) {
                    _endDrag = false;
                    this.renderer.is_dragging = true;
                }
            }
            if (_endDrag) {
                this.renderer.click_target = null;
                this.renderer.is_dragging = false;
                this.renderer.removeRepresentation(this);
                paper.view.draw();
            }
        },
        destroy: function() {
            this.arrow.remove();
            this.line.remove();
        }
    }).value();
//    });

    /* TempEdge Class End */

    return TempEdge;

});
