
define(['jquery', 'underscore', 'requtils', 'renderer/baserepresentation'], function ($, _, requtils, BaseRepresentation) {
    'use strict';

    var Utils = requtils.getUtils();

    /* Rkns.Renderer._BaseButton Class */

    /* BaseButton is extended by contextual buttons that appear when hovering on nodes and edges */

    var _BaseButton = Utils.inherit(BaseRepresentation);

    _(_BaseButton.prototype).extend({
        moveTo: function(_pos) {
            this.sector.moveTo(_pos);
        },
        show: function() {
            this.sector.show();
        },
        hide: function() {
            this.sector.hide();
        },
        select: function() {
            this.sector.select();
        },
        unselect: function(_newTarget) {
            this.sector.unselect();
            if (!_newTarget || (_newTarget !== this.source_representation && _newTarget.source_representation !== this.source_representation)) {
                this.source_representation.unselect();
            }
        },
        destroy: function() {
            this.sector.destroy();
        }
    }).value();
//    });

    return _BaseButton;

});
