
define(['jquery', 'underscore', 'requtils', 'renderer/baserepresentation'], function ($, _, requtils, BaseRepresentation) {
    'use strict';

    var Utils = requtils.getUtils();

    /* _BaseEditor Begin */
    //var _BaseEditor = Renderer._BaseEditor = Utils.inherit(Renderer._BaseRepresentation);
    var _BaseEditor = Utils.inherit(BaseRepresentation);

    _(_BaseEditor.prototype).extend({
        _init: function() {
            this.renderer.buttons_layer.activate();
            this.type = "editor";
            this.editor_block = new paper.Path();
            var _pts = _.map(_.range(8), function() {return [0,0];});
            this.editor_block.add.apply(this.editor_block, _pts);
            this.editor_block.strokeWidth = this.options.tooltip_border_width;
            this.editor_block.strokeColor = this.options.tooltip_border_color;
            this.editor_block.opacity = 0.8;
            this.editor_$ = $('<div>')
            .appendTo(this.renderer.editor_$)
            .css({
                position: "absolute",
                opacity: 0.8
            })
            .hide();
        },
        destroy: function() {
            this.editor_block.remove();
            this.editor_$.remove();
        }
    }).value();
//    });

    /* _BaseEditor End */

    return _BaseEditor;

});
