package org.iri_research.renkan.models;

import java.util.UUID;

import org.iri_research.renkan.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.geo.Point;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;

@Document(collection = "nodes")
@JsonIdentityInfo(generator=ObjectIdGenerators.UUIDGenerator.class, property="@id")
public class Node extends AbstractRenkanModel<String> {

    public Node(Node node, String projectId) {
        this(Constants.UUID_GENERATOR.generate().toString(), node.title,
                node.description, node.uri, node.style, node.createdBy,
                node.position, node.image, node.size, node.shape, node.type,
                node.hidden, projectId);
    }

    public Node(Node node) {
        this(node, node.projectId);
    }

    @SuppressWarnings("unused")
    private Node() {
    }

    @Autowired(required = true)
    public Node(String id, String title, String description, String uri,
            NodeStyle style, String createdBy, Point position, String image,
            Integer size, String shape, String type, Boolean hidden,
            String projectId) {
        super(id, title, description, uri);

        this.style = style;
        this.projectId = projectId;
        this.createdBy = createdBy;
        this.position = position;
        this.image = image;
        this.size = (size == null) ? 0 : size.intValue();
        this.shape = shape;
        this.type = type;
        this.hidden = (hidden == null) ? false : hidden.booleanValue();
    }

    @Field("project_id")
    @JsonProperty("project_id")
    private String projectId = null;

    @Field("created_by")
    @JsonProperty("created_by")
    private String createdBy = null;

    private NodeStyle style = null;
    
    private Point position = null;

    private String image;

    private int size;

    private String shape;

    private String type;

    private boolean hidden;

    public Point getPosition() {
        return position;
    }

    public String getImage() {
        return image;
    }

    @JsonProperty("project_id")
    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @JsonProperty("created_by")
    public String getCreatedBy() {
        return createdBy;
    }

    public int getSize() {
        return size;
    }

    public String getShape() {
        return shape;
    }

    public String getType() {
        return type;
    }

    public boolean isHidden() {
      return hidden;
    }

    @Override
    protected String getRawKeyPart() {
        return this.createdBy;
    }

    @Override
    protected String getDefaultId() {
        return UUID.randomUUID().toString();
    }

    public NodeStyle getStyle() {
        return style;
    }

    public void setStyle(NodeStyle style) {
        this.style = style;
    }

}
