/*
 * Decompiled with CFR 0.152.
 */
package org.coweb;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.coweb.ServiceHandler;
import org.coweb.SessionHandler;
import org.coweb.SessionManager;
import org.coweb.SessionModerator;
import org.coweb.UpdaterTypeMatcher;
import org.eclipse.jetty.util.ajax.JSON;

public class LateJoinHandler {
    protected SessionHandler sessionHandler = null;
    protected ServiceHandler serviceHandler = null;
    protected SessionManager sessionManager = null;
    protected SessionModerator sessionModerator = null;
    protected UpdaterTypeMatcher updaterTypeMatcher = null;
    protected boolean cacheState = true;
    private static final Logger log = Logger.getLogger(LateJoinHandler.class.getName());
    private Map<String, ServerSession> updatees = new HashMap<String, ServerSession>();
    protected Map<String, List<String>> updaters = new HashMap<String, List<String>>();
    protected ArrayList<String> siteids = new ArrayList(5);
    private Object[] lastState = null;
    private Map<String, ServerSession> clientids = new HashMap<String, ServerSession>();

    public LateJoinHandler(SessionHandler sessionHandler, Map<String, Object> config) {
        this.siteids.add(0, "reserved");
        for (int i = 1; i < 5; ++i) {
            this.siteids.add(i, null);
        }
        this.sessionHandler = sessionHandler;
        this.serviceHandler = this.sessionHandler.getServiceHandler();
        this.sessionManager = SessionManager.getInstance();
        if (config.containsKey("cacheState")) {
            this.cacheState = (Boolean)config.get("cacheState");
        }
        String classStr = "org.coweb.DefaultUpdaterTypeMatcher";
        if (config.containsKey("updaterTypeMatcher")) {
            classStr = (String)config.get("updaterTypeMatcher");
        }
        try {
            Class<UpdaterTypeMatcher> c = Class.forName(classStr).asSubclass(UpdaterTypeMatcher.class);
            this.updaterTypeMatcher = c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.sessionModerator = sessionHandler.getSessionModerator();
        ServerSession moderator = this.sessionModerator.getServerSession();
        this.siteids.set(0, moderator.getId());
        this.sessionModerator.setSessionAttribute("siteid", new Integer(0));
        this.clientids.put(moderator.getId(), moderator);
    }

    public ServerSession getServerSessionFromSiteid(String siteStr) {
        try {
            int siteid = Integer.valueOf(siteStr);
            String clientId = this.siteids.get(siteid);
            if (clientId == null) {
                return null;
            }
            return this.clientids.get(clientId);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void clearCacheState() {
        this.lastState = null;
    }

    public boolean onClientJoin(ServerSession client, Message message) {
        boolean first = false;
        int siteId = this.getSiteForClient(client);
        log.info("client site id = " + siteId);
        if (siteId == -1) {
            siteId = this.addSiteForClient(client);
            log.info("new site id = " + siteId);
        }
        Map<Integer, String> roster = this.getRosterList(client);
        Object[] data = new Object[]{};
        boolean sendState = false;
        Map ext = message.getExt();
        Map cobwebData = (Map)ext.get("coweb");
        String updaterType = (String)cobwebData.get("updaterType");
        client.setAttribute("updaterType", (Object)updaterType);
        log.info("updaterType = " + updaterType);
        if (this.updaters.isEmpty()) {
            this.addUpdater(client, false);
            sendState = true;
            first = true;
        } else if (this.lastState == null) {
            this.assignUpdater(client, updaterType);
            sendState = false;
        } else {
            data = this.lastState;
            sendState = true;
        }
        client.batch((Runnable)new BatchUpdateMessage(client, siteId, roster, data, sendState));
        return first;
    }

    public void onUpdaterSendState(ServerSession client, Message message) {
        String clientId = client.getId();
        Map data = message.getDataAsMap();
        String token = (String)data.get("token");
        if (token == null) {
            this.sessionHandler.removeBadClient(client);
            return;
        }
        List<String> tokens = this.updaters.get(clientId);
        if (tokens == null) {
            this.sessionHandler.removeBadClient(client);
            return;
        }
        if (!tokens.remove(token)) {
            this.sessionHandler.removeBadClient(client);
            return;
        }
        ServerSession updatee = this.updatees.get(token);
        if (updatee == null) {
            return;
        }
        this.updatees.remove(token);
        if (this.cacheState) {
            this.lastState = (Object[])data.get("state");
            log.fine("Cached state from updater.");
            log.fine(JSON.toString((Object[])this.lastState));
        }
        ServerMessage.Mutable msg = this.sessionManager.getBayeux().newMessage();
        msg.setChannel("/service/session/join/state");
        if (this.cacheState) {
            log.info("sending cached state");
            msg.setData((Object)this.lastState);
        } else {
            log.info("sending state from updater");
            msg.setData((Object)((Object[])data.get("state")));
        }
        msg.setLazy(false);
        updatee.deliver((Session)this.sessionManager.getServerSession(), msg);
    }

    public void onUpdaterSubscribe(ServerSession client, Message message) {
        this.addUpdater(client, true);
    }

    public boolean onClientRemove(ServerSession client) {
        log.info("siteId = " + client.getAttribute("siteid"));
        this.removeUpdater(client);
        if (this.getUpdaterCount() == 0) {
            log.info("removing last updater, ending coweb session");
            return true;
        }
        return false;
    }

    public boolean onEndSession() {
        this.updatees.clear();
        this.updaters.clear();
        this.siteids.clear();
        this.lastState = null;
        this.clientids.clear();
        return true;
    }

    protected void addUpdater(ServerSession serverSession, boolean notify) {
        String clientId = serverSession.getId();
        if (this.updaters.containsKey(clientId) && !this.updaters.isEmpty()) {
            return;
        }
        log.fine("adding " + clientId + " to list of updaters");
        this.updaters.put(clientId, new ArrayList());
        if (notify) {
            this.sendRosterAvailable(serverSession);
        }
    }

    private void sendRosterAvailable(ServerSession client) {
        log.info("sending roster available");
        ServerSession from = this.sessionManager.getServerSession();
        Integer siteId = (Integer)client.getAttribute("siteid");
        String username = (String)client.getAttribute("username");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("siteId", siteId);
        data.put("username", username);
        String rosterAvailableChannel = this.sessionHandler.getRosterAvailableChannel();
        for (ServerSession c : this.sessionHandler.getAttendees()) {
            c.deliver((Session)from, rosterAvailableChannel, data, null);
        }
    }

    protected void sendRosterUnavailable(ServerSession client) {
        log.fine("CollabSessionHandler::sendRosterUnavailable");
        BayeuxServer server = this.sessionManager.getBayeux();
        ConfigurableServerChannel.Initializer initializer = new ConfigurableServerChannel.Initializer(){

            public void configureChannel(ConfigurableServerChannel channel) {
                channel.setPersistent(true);
            }
        };
        String rosterUnavailableChannel = this.sessionHandler.getRosterUnavailableChannel();
        server.createIfAbsent(rosterUnavailableChannel, new ConfigurableServerChannel.Initializer[]{initializer});
        ServerChannel channel = server.getChannel(rosterUnavailableChannel);
        if (channel == null) {
            return;
        }
        ServerSession from = this.sessionManager.getServerSession();
        Integer siteId = (Integer)client.getAttribute("siteid");
        String username = (String)client.getAttribute("username");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("siteId", siteId);
        data.put("username", username);
        log.fine(((Object)data).toString());
        channel.publish((Session)from, data, null);
    }

    public String toString() {
        return "LateJoinHandler";
    }

    protected int getSiteForClient(ServerSession client) {
        if (this.siteids.contains(client.getId())) {
            return this.siteids.indexOf(client.getId());
        }
        return -1;
    }

    protected int addSiteForClient(ServerSession client) {
        int index = this.siteids.indexOf(null);
        if (index == -1) {
            index = this.siteids.size();
            this.siteids.ensureCapacity(this.siteids.size() + 1);
            this.siteids.add(index, client.getId());
        } else {
            this.siteids.set(index, client.getId());
        }
        client.setAttribute("siteid", (Object)new Integer(index));
        this.clientids.put(client.getId(), client);
        return index;
    }

    protected int removeSiteForClient(ServerSession client) {
        if (client == null) {
            log.severe("removeSiteForClient ******* client is null *******");
            return -1;
        }
        int siteid = this.siteids.indexOf(client.getId());
        if (siteid == -1) {
            log.severe("removeSiteForClient ****** Cannot find client in siteids list *******");
            Integer i = (Integer)client.getAttribute("siteid");
            if (i == null) {
                log.severe("******* Client Does not have siteId attribute - Ghost *******");
            }
            return -1;
        }
        this.siteids.set(siteid, null);
        return siteid;
    }

    protected Map<Integer, String> getRosterList(ServerSession client) {
        HashMap<Integer, String> roster = new HashMap<Integer, String>();
        for (String clientId : this.updaters.keySet()) {
            ServerSession c = this.clientids.get(clientId);
            Integer siteId = (Integer)c.getAttribute("siteid");
            roster.put(siteId, (String)c.getAttribute("username"));
        }
        return roster;
    }

    private void assignUpdater(ServerSession updatee, String updaterType) {
        String matchedType;
        log.info("assignUpdater *****************");
        ServerSession from = this.sessionManager.getServerSession();
        if (this.updaters.isEmpty()) {
            this.addUpdater(updatee, false);
            updatee.deliver((Session)from, "/service/session/join/state", new ArrayList(), null);
            return;
        }
        String updaterId = null;
        ServerSession updater = null;
        if (!updaterType.equals("default") && (matchedType = this.updaterTypeMatcher.match(updaterType, this.getAvailableUpdaterTypes())) != null) {
            for (String id : this.updaters.keySet()) {
                updater = this.clientids.get(id);
                if (!updater.getAttribute("updaterType").equals(matchedType)) continue;
                updaterId = id;
                log.fine("found an updater type matched to [" + matchedType + "]");
                break;
            }
        }
        if (updaterId == null) {
            Random r = new Random();
            int idx = r.nextInt(this.updaters.size());
            log.fine("using default updater type");
            Object[] keys = this.updaters.keySet().toArray();
            updaterId = (String)keys[idx];
            updater = this.clientids.get(updaterId);
        }
        log.fine("assigning updater " + updater.getAttribute("siteid") + " to " + updatee.getAttribute("siteid"));
        SecureRandom s = new SecureRandom();
        String token = new BigInteger(130, s).toString(32);
        this.updaters.get(updaterId).add(token);
        this.updatees.put(token, updatee);
        updater.deliver((Session)from, "/service/session/updater", (Object)token, null);
    }

    protected void removeUpdater(ServerSession client) {
        block4: {
            List<String> tokenList;
            block3: {
                log.fine("LateJoinHandler::removeUpdater " + client);
                this.removeSiteForClient(client);
                tokenList = this.updaters.get(client.getId());
                this.updaters.remove(client.getId());
                if (tokenList != null) break block3;
                for (String token : this.updatees.keySet()) {
                    ServerSession updatee = this.updatees.get(token);
                    if (!updatee.getId().equals(client.getId())) continue;
                    this.updatees.remove(token);
                }
                break block4;
            }
            log.fine("sending roster unavailable");
            this.sendRosterUnavailable(client);
            if (tokenList.isEmpty()) break block4;
            log.fine("this updater was updating someone");
            for (String token : tokenList) {
                ServerSession updatee = this.updatees.get(token);
                if (updatee == null) continue;
                String updaterType = (String)client.getAttribute("updaterType");
                if (updaterType == null) {
                    updaterType = "default";
                }
                this.assignUpdater(updatee, updaterType);
            }
        }
    }

    private int getUpdaterCount() {
        return this.updaters.size();
    }

    private List<String> getAvailableUpdaterTypes() {
        ArrayList<String> availableUpdaterTypes = new ArrayList<String>();
        for (String id : this.updaters.keySet()) {
            ServerSession updater = this.clientids.get(id);
            availableUpdaterTypes.add((String)updater.getAttribute("updaterType"));
        }
        return availableUpdaterTypes;
    }

    class BatchUpdateMessage
    implements Runnable {
        private ServerSession client = null;
        private Object data = null;
        private Map<Integer, String> roster = null;
        private int siteId = -1;
        private boolean sendState = false;

        BatchUpdateMessage(ServerSession client, int siteId, Map<Integer, String> roster, Object data, boolean sendState) {
            this.client = client;
            this.siteId = siteId;
            this.roster = roster;
            this.data = data;
            this.sendState = sendState;
        }

        @Override
        public void run() {
            SessionManager manager = SessionManager.getInstance();
            ServerSession server = manager.getServerSession();
            this.client.deliver((Session)server, "/service/session/join/siteid", (Object)this.siteId, null);
            this.client.deliver((Session)server, "/service/session/join/roster", this.roster, null);
            if (this.sendState) {
                this.client.deliver((Session)server, "/service/session/join/state", this.data, null);
            }
        }
    }
}

