/**
 * 
 */
package org.iri_research.renkan.coweb.event;

import java.util.List;
import java.util.Map;

import javax.inject.Named;

import org.iri_research.renkan.models.Project;
import org.iri_research.renkan.repositories.IRenkanRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author ymh
 *
 */
@Named
public class ProjectSyncEventManager extends AbstractSyncEventManager<Project, String> {

	private final Logger logger = LoggerFactory.getLogger(ProjectSyncEventManager.class);			
	
	@Override
	public IRenkanRepository<Project, String> getObjectRepository() {
		return this.getProjectsRepository();
	}
	
	/* (non-Javadoc)
	 * @see org.iri_research.renkan.coweb.event.AbstractSyncEventManager#insert(java.util.Map)
	 */
	@Override
	public void insert(Map<String, Object> data) {
		this.logger.debug("Insert called, do nothing");
		// do nothing
	}

	/* (non-Javadoc)
	 * @see org.iri_research.renkan.coweb.event.AbstractSyncEventManager#delete(java.util.Map)
	 */
	@Override
	public void delete(Map<String, Object> data) {
		this.logger.debug("Delete called, do nothing");
		// do nothing
	}

	/* (non-Javadoc)
	 * @see org.iri_research.renkan.coweb.event.AbstractSyncEventManager#nullOperation(java.util.Map)
	 */
	@Override
	public void nullOperation(Map<String, Object> data) {
		this.logger.debug("Null called, do nothing");
		// do nothing
	}

	@Override
	protected List<Project> getObjectList(Project project) {
		this.logger.error("Get object list called error");
		throw new UnsupportedOperationException("Get object list called error");
	}


}
