Rkns.Model = {}

Rkns.Model._BaseElement = function(_project, _props) {
    if (typeof _props !== "undefined") {
        this._project = _project;
        this.id = _props.id || Rkns.Utils.getUID(this.type);
        this.title = _props.title || "(untitled " + this.type + ")";
        this.description = _props.description || "";
        this.uri = _props.uri || "";
    }
}

Rkns.Model._BaseElement.prototype.addReference = function(_propName, _list, _id, _default) {
    var _element = _list.getElement(_id);
    if (typeof _element === "undefined" && typeof _default !== "undefined") {
        this[ _propName ] = _default;
        this[ _propName + "_id" ] = _default.id;
    } else {
        this[ _propName + "_id" ] = _id;
        this[ _propName ] = _element;
    }
}

Rkns.Model._BaseElement.prototype.updateGraphics = function() {
    this._project.renderer.redraw();
}

Rkns.Model._BaseElement.prototype.updateData = function() {
    this._project.serializer.save(this);
}

/* Element Class Generator */

Rkns.Model._elementClass = function(_type) {
    return Rkns.Utils.inherit(Rkns.Model._BaseElement, function() {
        this.type = _type;
    });
}

/* User Model */

Rkns.Model.User = Rkns.Model._elementClass("user");

Rkns.Model.User.prototype._init = function(_project, _props) {
    this.color = _props.color || "#666666";
}

/* Node Model */

Rkns.Model.Node = Rkns.Model._elementClass("node");

Rkns.Model.Node.prototype._init = function(_project, _props) {
    this.addReference("created_by", this._project.users, _props.created_by, _project.current_user);
    this.position = _props.position;
    this.description = _props.description || "";
}

Rkns.Model.Node.prototype.setPosition = function(_x, _y) {
    if (typeof _x === "object") {
        if (typeof _x.x !== "undefined" && typeof _x.y !== "undefined") {
            this.position.x = _x.x;
            this.position.y = _x.y;
        } else {
            if (typeof _x.length !== "undefined") {
                this.position.x = _x[0];
                this.position.y = _x[1];
            }
        }
    } else {
        if (typeof _y !== "undefined") {
            this.position.x = +_x;
            this.position.y = +_y;
        }
    }
}

/* Edge Model */

Rkns.Model.Edge = Rkns.Model._elementClass("edge");

Rkns.Model.Edge.prototype._init = function(_project, _props) {
    this.addReference("created_by", this._project.users, _props.created_by, _project.current_user);
    this.addReference("from", this._project.nodes, _props.from);
    this.addReference("to", this._project.nodes, _props.to);
}

/* List Helper Functions -- See Metadataplayer */

Rkns.Model.List = function() {
    Array.call(this);
    this.idIndex = [];
}

Rkns.Model.List.prototype = new Array();

Rkns.Model.List.prototype.hasId = function(_id) {
    return Rkns._(this.idIndex).include(_id);
}

Rkns.Model.List.prototype.getIds = function(_id) {
    return this.idIndex;
}

/* On recent browsers, forEach and map are defined and do what we want.
 * Otherwise, we'll use the Underscore.js functions
 */
if (typeof Array.prototype.forEach === "undefined") {
    Rkns.Model.List.prototype.forEach = function(_callback) {
        var _this = this;
        Rkns._(this).forEach(function(_value, _key) {
            _callback(_value, _key, _this);
        });
    }
}

if (typeof Array.prototype.map === "undefined") {
    Rkns.Model.List.prototype.map = function(_callback) {
        var _this = this;
        return Rkns._(this).map(function(_value, _key) {
            return _callback(_value, _key, _this);
        });
    }
}

/* We override Array's filter function because it doesn't return an Rkns.Model.List
 */
Rkns.Model.List.prototype.filter = function(_callback) {
    var _this = this,
        _res = new Rkns.Model.List();
    _res.addElements(Rkns._(this).filter(function(_value, _key) {
        return _callback(_value, _key, _this);
    }));
    return _res;
}

Rkns.Model.List.prototype.slice = function(_start, _end) {
    var _res = new Rkns.Model.List();
    _res.addElements(Array.prototype.slice.call(this, _start, _end));
    return _res;
}

Rkns.Model.List.prototype.splice = function(_start, _end) {
    var _res = new Rkns.Model.List();
    _res.addElements(Array.prototype.splice.call(this, _start, _end));
    this.idIndex.splice(_start, _end);
    return _res;
}

/* Array has a sort function, but it's not as interesting as Underscore.js's sortBy
 * and won't return a new Rkns.Model.List
 */
Rkns.Model.List.prototype.sortBy = function(_callback) {
    var _this = this,
        _res = new Rkns.Model.List();
    _res.addElements(Rkns._(this).sortBy(function(_value, _key) {
        return _callback(_value, _key, _this);
    }));
    return _res;
}

Rkns.Model.List.prototype.push = function(_el) {
    if (typeof _el === "undefined" || typeof _el.id === "undefined") {
        return;
    }
    var _index = (Rkns._(this.idIndex).indexOf(_el.id));
    if (_index === -1) {
        this.idIndex.push(_el.id);
        Array.prototype.push.call(this, _el);
    } else {
        this[_index] = _el;
    }
}

Rkns.Model.List.prototype.addElements = function(_array) {
    var _this = this;
    Rkns._(_array).forEach(function(_el) {
        _this.push(_el);
    });
}

Rkns.Model.List.prototype.removeId = function(_id) {
    var _index = (Rkns._(this.idIndex).indexOf(_id));
    if (_index !== -1) {
        this.splice(_index,1);
    }
}

Rkns.Model.List.prototype.removeIds = function(_list) {
    var _this = this;
    Rkns._(_list).forEach(function(_id) {
        _this.removeId(_id);
    });
}

Rkns.Model.List.prototype.getElement = function(_id) {
    var _index = Rkns._(this.idIndex).indexOf(_id);
    if (_index === -1) {
        return undefined;
    } else {
        return this[_index];
    }
}
