package org.iri_research.renkan.test.repositories;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import org.iri_research.renkan.models.Space;
import org.iri_research.renkan.repositories.SpacesRepository;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration("repositories-context.xml")
public class SpacesRepositoryTest {
	
	private Logger logger = LoggerFactory.getLogger(SpacesRepositoryTest.class);
	
	@Autowired
	private SpacesRepository spacesRepository;

	@Autowired
	private MongoTemplate mongoTemplate;
	
	private Map<String, Space> spacesList = new HashMap<String, Space>();

	
	@Before
	public void setup() {
		
		logger.debug("Setup");
		spacesRepository.deleteAll();
		Date creationDate = new Date();
		String uuid = UUID.randomUUID().toString();
		Space testSpace = new Space(uuid, "test", "Test space", "{}", "http://ldt.iri.centrepompidou.fr", "#ababab", "test_user", "http://ldt.iri.centrepompidou.fr", creationDate);
		testSpace = spacesRepository.save(testSpace);
		this.spacesList.put(uuid, testSpace);
	}
	
	@Test
	public void testFieldMapping() {
		// query json directly with mongodb driver
		// check field values
		DBCollection coll = mongoTemplate.getCollection(mongoTemplate.getCollectionName(Space.class));
		
		for(DBObject obj: coll.find()) {
			Assert.assertTrue("mongo object must have _id field", obj.containsField("_id"));

			String id = obj.get("_id").toString();
			
			Space sp = this.spacesList.get(id);
			
			Assert.assertTrue("mongo object must have title field", obj.containsField("title"));
			Assert.assertEquals("Titles must be the same", obj.get("title"), sp.getTitle());

			Assert.assertTrue("mongo object must have description field", obj.containsField("description"));
			Assert.assertEquals("description must be the same", obj.get("description"), sp.getDescription());

			Assert.assertTrue("mongo object must have color field", obj.containsField("color"));
			Assert.assertEquals("Color must be the same", obj.get("color"), sp.getColor());

			Assert.assertTrue("mongo object must have uri field", obj.containsField("uri"));
			Assert.assertEquals("Uri must be the same", obj.get("uri"), sp.getUri());

			Assert.assertTrue("mongo object must have image field", obj.containsField("image"));
			Assert.assertEquals("Image must be the same", obj.get("image"), sp.getImage());
			
			Assert.assertTrue("mongo object must have created field", obj.containsField("created"));
			Assert.assertEquals("Created must be the same", obj.get("created"), sp.getCreated());

			Assert.assertTrue("mongo object must have bin_config field", obj.containsField("bin_config"));
			Assert.assertEquals("Uri must be the same", obj.get("bin_config"), sp.getBinConfig());

			Assert.assertTrue("mongo object must have created_by field", obj.containsField("created_by"));
			Assert.assertEquals("created by must be the same", obj.get("created_by"), sp.getCreatedBy());			
			
		}
		
	}
	
	@After
	public void teardown() {
		spacesRepository.deleteAll();
	}

	
}
