package org.iri_research.renkan.controller;

import java.util.HashMap;
import java.util.Map;

import org.iri_research.renkan.models.Project;
import org.iri_research.renkan.repositories.ProjectsRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;


@Controller
@RequestMapping("/")
public class RenkanRootController {

	@SuppressWarnings("unused")
	private final Logger logger = LoggerFactory.getLogger(RenkanRootController.class);
		
	@Autowired
	private ProjectsRepository projectRepository;
		
	@RequestMapping(value="", method = RequestMethod.GET, produces={"text/html;charset=UTF-8"})
	public ModelAndView renkanIndex() {
				
		Map<String, Object> model = new HashMap<String, Object>();
		
		Iterable<Project> projects = this.projectRepository.findAll();
		
		model.put("projects", projects);
		
		return new ModelAndView("renkanIndex", model);
	}
	
		
}
