package org.iri_research.renkan.repositories;

import org.iri_research.renkan.models.Project;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;
import static org.springframework.data.mongodb.core.query.Query.query;
import static org.springframework.data.mongodb.core.query.Criteria.where;
import org.springframework.data.mongodb.core.query.Update;

@Component
public class ProjectsRepositoryImpl implements ProjectsRepositoryCustom {	
	
	@Autowired
	private MongoTemplate mongoTemplate;
	
	@Override
	public int getRevCounter(String projectId)  {		
		Project p = this.mongoTemplate.findAndModify(query(where("id").is(projectId)), new Update().inc("revCounter", 1), Project.class);
		
		if(p == null) {
			return -1;
		}
		return p.getRevCounter();
	}

}
