package org.iri_research.renkan.repositories;

import java.util.Date;

import org.iri_research.renkan.RenkanException;
import org.iri_research.renkan.models.Project;
import org.iri_research.renkan.models.ProjectSync;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectSyncsRepositoryImpl implements ProjectSyncsRepositoryCustom {

    @Autowired
    private ProjectsRepository projectRepository;

    @Override
    public ProjectSync getProjectSync(String data, Project project, String user)
            throws RenkanException {

        if (project == null) {
            throw new RenkanException("ProjectSyncsRepository : Null Project.");
        }

        ProjectSync ps = new ProjectSync(null, data, project,
                this.projectRepository.getRevCounter(project.getId()),
                new Date(System.currentTimeMillis()), user);

        return ps;
    }

    @Override
    public ProjectSync getProjectSync(String data, String project_id,
            String user) throws RenkanException {

        if (project_id == null || "".equals(project_id)) {
            throw new RenkanException(
                    "ProjectSyncsRepository : Null or empty project id.");
        }

        Project p = this.projectRepository.findOne(project_id);

        if (p == null) {
            throw new RenkanException(
                    "ProjectSyncsRepository : project not found for id "
                            + project_id);
        }

        return this.getProjectSync(data, p, user);

    }

}
