package org.iri_research.renkan.models;

import java.util.Collection;
import java.util.Date;

import javax.annotation.Resource;

import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;

@Document(collection = "users")
public class User extends AbstractRenkanModel<String> implements UserDetails {

    private static final long serialVersionUID = 6972038893086220548L;
    
    
    @Resource(name="renkanPasswordEncoder")
    private PasswordEncoder passwordEncoder;

    private String avatar;
    @Field("credentials_expiration_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone = "GMT")
    private Date credentialExpirationDate;
    private String email;
    private boolean enabled;
    @Field("expiration_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone = "GMT")
    private Date expirationDate;

    private boolean locked;

    private String password;

    public User() {
    }

    public User(String id, String title, String description, String uri,
            String color) {
        super(id, title, description, uri, color);
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        // TODO Auto-generated method stub
        return null;
    }

    public String getAvatar() {
        return avatar;
    }

    public String getColor() {
        return this.color;
    }

    public Date getCredentialExpirationDate() {
        return credentialExpirationDate;
    }

    public String getEmail() {
        return email;
    }

    public Date getExpirationDate() {
        return expirationDate;
    }

    @Override
    @JsonIgnore
    public String getPassword() {
        return this.password;
    }

    @Override
    @JsonIgnore
    public String getUsername() {
        return this.title;
    }

    @Override
    public boolean isAccountNonExpired() {
        return this.expirationDate == null
                || this.expirationDate.after(new Date());
    }

    @Override
    public boolean isAccountNonLocked() {
        return !this.locked;
    }

    @Override
    public boolean isCredentialsNonExpired() {
        return this.credentialExpirationDate == null
                || this.credentialExpirationDate.after(new Date());
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isLocked() {
        return locked;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public void setCredentialExpirationDate(Date credentialExpirationDate) {
        this.credentialExpirationDate = credentialExpirationDate;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    protected String getRawKeyPart() {
        return "";
    }

    public void setRawPassword(String password) {
        this.password = this.passwordEncoder.encode(password);
    }

}
