package org.iri_research.renkan.models;

import java.util.Date;

import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;

import com.fasterxml.jackson.annotation.JsonFormat;

@Document(collection = "projectSyncs")
public class ProjectSync {

    private ObjectId id;

    private String data;

    @DBRef
    private Project project;

    private int revision;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone = "GMT")
    private Date created;

    private String user;

    public ProjectSync(ObjectId id, String data, Project project, int revision,
            Date created, String user) {
        this.id = id;
        this.data = data;
        this.project = project;
        this.revision = revision;
        this.created = created;
        this.user = user;
        if (this.created == null) {
            this.created = new Date(System.currentTimeMillis());
        }
    }

    public ObjectId getId() {
        return id;
    }

    public String getData() {
        return data;
    }

    public Project getProject() {
        return project;
    }

    public int getRevision() {
        return revision;
    }

    public String getUser() {
        return user;
    }

}
