package org.iri_research.renkan.forms;

import java.util.Date;

import org.iri_research.renkan.Constants;
import org.iri_research.renkan.models.User;
import org.iri_research.renkan.repositories.IRenkanRepository;
import org.iri_research.renkan.repositories.UsersRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserForm extends RenkanForm<String, User> {

    private String avatar;

    private Date credentialExpirationDate;

    private String email;

    private boolean enabled;
    private Date expirationDate;
    private boolean locked;
    private String password;
    private String passwordConfirm;
    @Autowired
    private UsersRepository usersRepository;
    
    
    public UserForm() {
        super();
    }
    
    public UserForm(User model) {
        super(model);
        if (model != null) {
            this.avatar = model.getAvatar();
            this.credentialExpirationDate = model.getCredentialExpirationDate();
            this.email = model.getEmail();
            this.expirationDate = model.getExpirationDate();
            this.enabled = model.isEnabled();
            this.locked = model.isLocked();
        }
    }

    public String getAvatar() {
        return avatar;
    }

    public Date getCredentialExpirationDate() {
        return credentialExpirationDate;
    }

    public String getEmail() {
        return email;
    }

    public Date getExpirationDate() {
        return expirationDate;
    }

    @Override
    protected User getModelInstance() {
        return new User();
    }

    public String getPassword() {
        return password;
    }

    public String getPasswordConfirm() {
        return passwordConfirm;
    }

    @Override
    protected IRenkanRepository<User, String> getRepository() {
        return this.usersRepository;
    }

    public UsersRepository getUsersRepository() {
        return usersRepository;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public boolean isLocked() {
        return locked;
    }

    @Override
    protected void saveToModel() {
        if (this.getId() == null || this.getId().length() == 0) {
            this.model.setId(Constants.UUID_GENERATOR.generate().toString());
        }
        this.model.setAvatar(this.avatar);
        this.model.setEmail(this.email);
        this.model.setCredentialExpirationDate(this.credentialExpirationDate);
        this.model.setExpirationDate(this.expirationDate);
        this.model.setEnabled(this.enabled);
        this.model.setLocked(this.locked);
        this.model.setRawPassword(this.password);

    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public void setCredentialExpirationDate(Date credentialExpirationDate) {
        this.credentialExpirationDate = credentialExpirationDate;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPasswordConfirm(String passwordConfirm) {
        this.passwordConfirm = passwordConfirm;
    }

    @Autowired
    public void setUsersRepository(UsersRepository usersRepository) {
        this.usersRepository = usersRepository;
    }

}
