Rkns.Ldt = {}

Rkns.Ldt.ProjectBin = Rkns.Utils.inherit(Rkns._BaseBin);

Rkns.Ldt.ProjectBin.prototype.tagTemplate = Rkns._.template(
    '<li class="Rk-Bin-Item" data-uri="<%=ldt_platform%>ldtplatform/ldt/front/search/?search=<%=encodedtitle%>&field=all" data-title="<%-title%>" data-description="Tag \'<%-title%>\'">'
    + '<div class="Rk-Ldt-Icon Rk-Ldt-TagIcon"></div><h4><%-title%></h4></li>'
);

Rkns.Ldt.ProjectBin.prototype.annotationTemplate = Rkns._.template(
    '<li class="Rk-Bin-Item" data-uri="<%=ldt_platform%>ldtplatform/ldt/front/player/<%=mediaid%>/#id=<%=annotationid%>" data-title="<%-title%>" data-description="<%-description%>">'
    + '<div class="Rk-Ldt-Icon Rk-Ldt-<%=type%>Icon"></div><h4><%-title%></h4><p><%-description%></p><p>Start: <%=start%>, End: <%=end%>, Duration: <%=duration%></p></li>'
);

Rkns.Ldt.ProjectBin.prototype._init = function(_renkan, _opts) {
    this.proj_id = _opts.project_id;
    this.ldt_platform = _opts.ldt_platform || "http://ldt.iri.centrepompidou.fr/";
    this.title_$.html(_opts.title);
    var _this = this;
    function convertTC(_ms) {
        function pad(_n) {
            var _res = _n.toString();
            while (_res.length < 2) {
                _res = '0' + _res;
            }
            return _res;
        }
        var _totalSeconds = Math.abs(Math.floor(_ms/1000)),
            _hours = Math.floor(_totalSeconds / 3600),
            _minutes = (Math.floor(_totalSeconds / 60) % 60),
            _seconds = _totalSeconds % 60,
            _res = '';
        if (_hours) {
            _res += pad(_hours) + ':'
        }
        _res += pad(_minutes) + ':' + pad(_seconds);
        return _res;
    }
    Rkns.$.getJSON(
        this.ldt_platform + 'ldtplatform/ldt/cljson/id/' + this.proj_id + '?callback=?',
        function(_data) {
            var _html = '<li><h3>Tags</h3></li>',
                _projtitle = _data.meta["dc:title"];
            _this.title_$.html('LDT Project: "' + _projtitle + '"');
            _html += Rkns._(_data.tags).map(function(_tag) {
                var _title = _tag.meta["dc:title"]
                return _this.tagTemplate({
                    ldt_platform: _this.ldt_platform,
                    title: _title,
                    encodedtitle : encodeURIComponent(_title)
                })
            }).join("");
            _html += '<li><h3>Annotations</h3></li>';
            _html += Rkns._(_data.annotations).map(function(_annotation) {
                var _description = _annotation.content.description,
                    _title = _annotation.content.title.replace(_description,""),
                    _duration = _annotation.end - _annotation.begin;
                return _this.annotationTemplate({
                    ldt_platform: _this.ldt_platform,
                    title: _title,
                    description: _description,
                    start: convertTC(_annotation.begin),
                    end: convertTC(_annotation.end),
                    duration: convertTC(_duration),
                    mediaid: _annotation.media,
                    annotationid: _annotation.id,
                    type: _duration ? "Segment" : "Point"
                });
            }).join("");
            
            _this.main_$.html(_html);
            _renkan.resizeBins();
        }
    );
}