/* 
 *  Copyright 2012 Institut de recherche et d'innovation 
 *  contributor(s) : Yves-Marie Haussonne, Raphael Velt, Samuel Huron
 *   
 *  contact@iri.centrepompidou.fr
 *  http://www.iri.centrepompidou.fr 
 *   
 *  This software is a computer program whose purpose is to show and add annotations on a video .
 *  This software is governed by the CeCILL-C license under French law and
 *  abiding by the rules of distribution of free software. You can  use, 
 *  modify and/ or redistribute the software under the terms of the CeCILL-C
 *  license as circulated by CEA, CNRS and INRIA at the following URL
 *  "http://www.cecill.info". 
 *  
 *  The fact that you are presently reading this means that you have had
 *  knowledge of the CeCILL-C license and that you accept its terms.
*/

/* Declaring the Renkan Namespace Rkns and Default values */

if (typeof Rkns !== "object") {
    Rkns = {}
}

Rkns.$ = jQuery;

Rkns._ = _;

Rkns._BaseBin = function(_renkan, _opts) {
    if (typeof _renkan !== "undefined") {
        this.renkan = _renkan;
        this.renkan.$.find(".Rk-Bin-Main").hide();
        this.$ = Rkns.$('<li>')
            .addClass("Rk-Bin")
            .appendTo(_renkan.$.find(".Rk-Bin-List"));
        this.title_icon_$ = Rkns.$('<span>')
            .addClass("Rk-Bin-Title-Icon")
            .appendTo(this.$);
        var _this = this;
        Rkns.$('<span>')
            .addClass("Rk-Bin-Close")
            .html('&times;')
            .appendTo(this.$)
            .click(function() {
                _this.destroy();
            });
        this.title_$ = Rkns.$('<h2>')
            .addClass("Rk-Bin-Title")
            .appendTo(this.$);
        this.main_$ = Rkns.$('<div>')
            .addClass("Rk-Bin-Main")
            .appendTo(this.$);
        this.title_$.html(_opts.title || '(new bin)');
        this.renkan.resizeBins();
    }
}

Rkns._BaseBin.prototype.destroy = function() {
    this.$.detach();
    this.renkan.resizeBins();
}

/* Point of entry */

Rkns.Renkan = function(_opts) {
    if (typeof _opts.language !== "string" || typeof Rkns.i18n[_opts.language] == "undefined") {
        _opts.language = "en";
    }
    if (typeof _opts.container !== "string") {
        _opts.container = "renkan";
    }
    if (typeof _opts.search !== "object" || !_opts.search) {
        _opts.search = [];
    }
    this.project = new Rkns.Models.Project();
    this.language = _opts.language;
    this.l10n = Rkns.i18n[_opts.language];
    if (typeof _opts.user_id !== "undefined") {
        this.current_user = _opts.user_id;
    }
    this.$ = Rkns.$("#" + _opts.container);
    this.$
        .addClass("Rk-Main")
        .html(this.template());
    this.renderer = new Rkns.Renderer.Scene(this);
    this.tabs = [];
    this.search_engines = [];
    this.selected_bin_item = undefined;
    var _this = this;
    this.$.mouseup(function() {
        _this.selected_bin_item = undefined;
        _this.$.find(".Rk-Bin-Item.dragging").removeClass("dragging");
    });
    if (!_opts.search.length) {
        this.$.find(".Rk-Search-Form").detach();
    } else {
        var _tmpl = Rkns._.template('<li class="<%= className %>" data-key="<%= key %>"><%= title %></li>'),
            _select = this.$.find(".Rk-Search-List"),
            _input = this.$.find(".Rk-Search-Input")
            _form = this.$.find(".Rk-Search-Form");
        Rkns._(_opts.search).each(function(_search, _key) {
            var _searchObj = new _search.type(_this, _search);
            _this.search_engines.push(_searchObj);
        });
        _select.html(
            Rkns._(this.search_engines).map(function(_search, _key) {
                return _tmpl({
                    key: _key,
                    title: _search.getSearchTitle(),
                    className: _search.getBgClass()
                });
            }).join("")
        );
        _select.find("li").click(function() {
            var _el = Rkns.$(this);
            _this.setSearchEngine(_el.attr("data-key"));
            _form.submit();
        });
        _form.submit(function() {
            if (_input.val()) {
                var _search = _this.search_engine;
                _search.search(_input.val());
            }
            return false;
        });
        this.$.find(".Rk-Search-Current").mouseenter(
            function() { _select.slideDown(); }
        );
        this.$.find(".Rk-Search-Select").mouseleave(
            function() { _select.slideUp(); }
        );
        this.setSearchEngine(0);
    }
    Rkns._(_opts.bins).each(function(_bin) {
        _this.tabs.push(new _bin.bin(_this, _bin));
    })
    
    /* The bins are not yet populated, but we want to bind dragging functions
     * here, as it will be easier than in the bins. Therefore, we bind to Rk-Bins
     * and look where the click was. */
    function findItem(_event) {
        var _t = Rkns.$(_event.target);
        while (!_t.is(".Rk-Bins,.Rk-Bin-Item")) {
            _t = _t.parent();
        }
        if (_t.is(".Rk-Bin-Item")) {
            return _t
        } else {
            return null;
        }
    }
    
    this.$.find(".Rk-Bins")
        .click(function(_e) {
            if (Rkns.$(_e.target).is(".Rk-Bin-Title,.Rk-Bin-Title-Icon")) {
                var _mainDiv = Rkns.$(_e.target).siblings(".Rk-Bin-Main");
                if (_mainDiv.is(":hidden")) {
                    _this.$.find(".Rk-Bin-Main").slideUp();
                    _mainDiv.slideDown();
                }
            }
        }).mousedown(function(_e) {
            var _t = findItem(_e);
            if (_t) {
                _t.addClass("dragging");
                _this.selected_bin_item = {
                    uri : $(_t).attr("data-uri"),
                    title : $(_t).attr("data-title"),
                    description : $(_t).attr("data-description")
                }
                return false;
            }
        }).mouseover(function(_e) {
            var _t = findItem(_e);
            if (_t && $(_t).attr("data-uri")) {
                var _models = _this.project.get("nodes").where({
                    uri: $(_t).attr("data-uri")
                });
                Rkns._(_models).each(function(_model) {
                    _this.renderer.highlightModel(_model);
                });
            }
        }).mouseout(function() {
            _this.renderer.unhighlightAll();
        });
    Rkns.$(window).resize(function() {
        _this.resizeBins();
    });
}

Rkns.Renkan.prototype.template = Rkns._.template(
    '<div class="Rk-Title"><h1>Hyper Plateau</h1></div><div class="Rk-Bins">'
    + '<form class="Rk-Search-Form"><input class="Rk-Search-Input" type="text" placeholder="Search" />'
    + '<div class="Rk-Search-Select"><div class="Rk-Search-Current"></div><ul class="Rk-Search-List"></ul></div>'
    + '<input type="submit" value="" class="Rk-Search-Submit" /></form>'
    + '<ul class="Rk-Bin-List"></ul></div><div class="Rk-Render Rk-Render-Panel"></div>'
);


Rkns.Renkan.prototype.setSearchEngine = function(_key) {
    this.search_engine = this.search_engines[_key];
    this.$.find(".Rk-Search-Current").attr("class","Rk-Search-Current " + this.search_engine.getBgClass());
}

Rkns.Renkan.prototype.resizeBins = function() {
    var _d = + this.$.find(".Rk-Search-Form").outerHeight();
    this.$.find(".Rk-Bin-Title").each(function() {
        _d += Rkns.$(this).outerHeight();
    });
    this.$.find(".Rk-Bin-Main").css({
        height: this.$.find(".Rk-Bins").height() - _d
    });
}

/* Utility functions */

Rkns.Utils = {
    _ID_AUTO_INCREMENT : 0,
    _ID_BASE : (function(_d) {
        function pad(n){return n<10 ? '0'+n : n}
        function fillrand(n) {
            var _res = ''
            for (var i=0; i<n; i++) {
                _res += Math.floor(16*Math.random()).toString(16);
            }
            return _res;
        }
        return _d.getUTCFullYear() + '-'  
            + pad(_d.getUTCMonth()+1) + '-'  
            + pad(_d.getUTCDate()) + '-'
            + fillrand(16);
    })(new Date()),
    getUID : function(_base) {
        var _n = (++this._ID_AUTO_INCREMENT).toString(16),
            _base = (typeof _base === "undefined" ? "" : _base + "-" );
        while (_n.length < 4) {
            _n = '0' + _n
        }
        return _base + this._ID_BASE + '-' + _n;
    },
    inherit : function(_baseClass, _callbefore) {
        var _class = function() {
            if (typeof _callbefore === "function") {
                _callbefore.apply(this, Array.prototype.slice.call(arguments, 0));
            }
            _baseClass.apply(this, Array.prototype.slice.call(arguments, 0));
            if (typeof this._init == "function") {
                this._init.apply(this, Array.prototype.slice.call(arguments, 0));
            }
        }
        _class.prototype = new _baseClass();
        return _class;
    }
}