Rkns.Wikipedia = {
}

Rkns.Wikipedia.Search = function(_renkan, _opts) {
    this.renkan = _renkan;
    this.lang = _opts.lang || "en";
}

Rkns.Wikipedia.Search.prototype.getBgClass = function() {
    return "Rk-Wikipedia-Search-Icon Rk-Wikipedia-Lang-" + this.lang;
}

Rkns.Wikipedia.Search.prototype.getSearchTitle = function() {
    return ( this.renkan.l10n["wiki_" + this.lang] || this.renkan.l10n.wiki_) ;
}

Rkns.Wikipedia.Search.prototype.search = function(_q) {
    this.renkan.tabs.push(
        new Rkns.Wikipedia.Bin(this.renkan, {
            lang: this.lang,
            search: _q
        })
    );
}

Rkns.Wikipedia.Bin = Rkns.Utils.inherit(Rkns._BaseBin);

Rkns.Wikipedia.Bin.prototype.resultTemplate = Rkns._.template(
    '<li class="Rk-Wikipedia-Result Rk-Bin-Item" data-uri="<%=wpurl%>" '
    + 'data-title="Wikipedia: <%=result.title%>" data-description="<%=wpdesc%>">'
    + '<div class="Rk-Wikipedia-Icon"></div><h4 class="Rk-Wikipedia-Title"><a href="<%=wpurl%>" target="_blank"><%=highlightedtitle%></a></h4>'
    + '<p class="Rk-Wikipedia-Snippet"><%=result.snippet%></p></li>'
);

Rkns.Wikipedia.Bin.prototype._init = function(_renkan, _opts) {
    this.search = _opts.search;
    this.lang = _opts.lang || "en";
    this.title_icon_$.addClass('Rk-Wikipedia-Title-Icon Rk-Wikipedia-Lang-' + this.lang);
    this.title_$.html(this.search).addClass("Rk-Wikipedia-Title");
    var _this = this;
    Rkns.$.getJSON(
        "http://" + _this.lang + ".wikipedia.org/w/api.php?action=query&list=search&srsearch=" + encodeURIComponent(this.search) + "&format=json&callback=?",
        function(_data) {
            var _rgxp = new RegExp('('+_this.search.replace(/(\W)/g,'\\$1')+')','gi'),
                _html = Rkns._(_data.query.search).map(function(_result) {
                return _this.resultTemplate({
                    result: _result,
                    wpurl: "http://" + _this.lang + ".wikipedia.org/wiki/" + encodeURI(_result.title.replace(/ /g,"_")),
                    highlightedtitle: _result.title.replace(_rgxp, "<span class='searchmatch'>$1</span>"),
                    wpdesc: Rkns.$('<div>').html(_result.snippet).text()
                });
            }).join("");
            _this.main_$.html(_html);
            _renkan.resizeBins();
        }
    );
}