package org.iri_research.renkan.models;

import org.springframework.data.mongodb.core.geo.Point;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import com.fasterxml.jackson.annotation.JsonProperty;

@Document(collection="nodes")
public class Node extends AbstractRenkanModel<String> {


	public Node(String id, String title, String description, String uri, String color, String createdBy, Point position, String image, String projectId) {
		super(id, title, description, uri, color);
		
		this.projectId = projectId;
		this.createdBy = createdBy;
		this.position = position;
		this.image = image;
	}	

	@Field("project_id")
	@JsonProperty("project_id")	
	private String projectId = null;	

	@Field("created_by")
	@JsonProperty("created_by")
	private String createdBy = null;
	
	private Point position = null;

	public Point getPosition() {
		return position;
	}

	private String image;

	public String getImage() {
		return image;
	}

	@JsonProperty("project_id")
	public String getProjectId() {
		return projectId;
	}

	@JsonProperty("created_by")
	public String getCreatedBy() {
		return createdBy;
	}

}
