Rkns.ListBin = Rkns.Utils.inherit(Rkns._BaseBin);

Rkns.ListBin.prototype.resultTemplate = Rkns._.template(
    '<li class="Rk-Bin-Item Rk-ListBin-Item" draggable="true" data-uri="<%-url%>" '
    + 'data-title="<%-title%>" data-description="<%-description%>" data-image="<%-image%>">'
    + '<% if (image) { %><img class="Rk-ListBin-Image" src="<%-image%>"><% } %></div><h4 class="Rk-ListBin-Title"><a href="<%-url%>" target="_blank"><%=htitle%></a></h4>'
    + '<% if (description) { %><p class="Rk-ListBin-Description"><%=hdescription%></p><% } %><% if (image) { %><div style="clear: both;"></div><% } %></li>'
);

Rkns.ListBin.prototype._init = function(_renkan, _opts) {
	this.renkan = _renkan;
    this.title_$.html(_opts.title);
    if (_opts.list) {
    	this.data = _opts.list;
    }
    this.refresh();
}

Rkns.ListBin.prototype.render = function(searchstr) {
    if (searchstr) {
    	var _rgxp = new RegExp('('+(searchstr).replace(/(\W)/g,'\\$1')+')','gi'),
    		rxtest = new RegExp(searchstr.replace(/(\W)/g,'\\$1'),'i');
    }
    function highlight(_text) {
    	if (searchstr) {
    		return _text.replace(_rgxp, "<span class='searchmatch'>$1</span>");
    	} else {
    		return _text;
    	}
    }
    var _html = "",
        _this = this,
        count = 0;
    Rkns._(this.data).each(function(_element) {
        var title = _element.title || _element.url || "",
            url = _element.url || "",
            description = _element.description || "",
            image = _element.image || "";
        if (searchstr && !rxtest.test(title) && !rxtest.test(description)) {
            return;
        }
        count++;
        _html += _this.resultTemplate({
            url: url,
            title: title,
            htitle: highlight(title),
            image: image,
            description: description,
            hdescription: highlight(description),
            static_url: _this.renkan.static_url
        });
    });
    _this.main_$.html(_html);
    if (searchstr && count) {
        this.count_$.text(count).show();
    } else {
        this.count_$.hide();
    }
    if (searchstr && !count) {
        this.$.hide();
    } else {
        this.$.show();
    }
    this.renkan.resizeBins();
}
    
Rkns.ListBin.prototype.refresh = function() {
    if (this.data) {
    	this.render();
    }
}