package org.iri_research.renkan.forms;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

@Component
public class GroupFormValidator implements Validator {

    @SuppressWarnings("unused")
    private Logger logger = LoggerFactory.getLogger(GroupFormValidator.class);

    @Override
    public boolean supports(Class<?> clazz) {
        return GroupForm.class.equals(clazz);
    }

    @Override
    public void validate(Object target, Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "title",
                "renkan.error.name.empty");
    }

}
