package org.iri_research.renkan.models;

import org.springframework.data.mongodb.core.geo.Point;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="nodes")
public class Node extends AbstractRenkanModel<String> {


	public Node(String id, String title, String description, String uri, String color, String project_id, String created_by, Point position, String image) {
		super(id, title, description, uri, color);
		
		this.project_id = project_id;
		this.created_by = created_by;
		this.position = position;
		this.image = image;
	}	
	
	private String project_id = null;	

	private String created_by = null;
	
	private Point position = null;

	public Point getPosition() {
		return position;
	}

	private String image;

	public String getImage() {
		return image;
	}

	public String getProject_id() {
		return project_id;
	}

	public String getCreated_by() {
		return created_by;
	}

}
