/* Imports a KC graph */

Rkns.retrieveKC = function(_renkan, _opts) {
    if (typeof _opts === "undefined") {
        var _opts = {};
    }
    var _proj = _renkan.project,
        _username = _opts.user_name || "Yves-Marie",
        _userid = _opts.user_id || "yves-marie.haussonne@centrepompidou.fr",
        _usercolor = _opts.user_color || "#800000",
        _allid = _opts.all_id || "B0000044",
        _projid = _opts.proj || "ozu_silent",
        _kcept = _opts.endpoint || "/sites/kcproxy/allRetrieve.jsp";
    var _load = function() {
        Rkns.$.getJSON(_kcept,
        {
            all_id: _allid,
            proj: _projid,
            uid: _userid
        },
        function(_data) {
            _proj.addUser({
                id: _userid,
                color: _usercolor,
                title: _username
            });
            Rkns._(_data.node).each(function(_node) {
                _proj.addNode({
                    id: _node.id,
                    title: _node.name,
                    description: 'Knowledge concierge node from project "' + _projid + '" belonging to group "' + _node.grp + '"',
                    position: {
                        x: _node.x,
                        y: _node.y
                    },
                    created_by: _userid
                });
            });
            Rkns._(_data.edge).each(function(_edge) {
                _proj.addEdge({
                    id: _edge.asc_id,
                    from: _edge.id,
                    to: _edge.to_id,
                    created_by: _userid,
                    title: _edge.r_name
                });
            });
        });
    };
    _load();
};
