package org.iri_research.renkan.models;

import java.util.UUID;

import org.iri_research.renkan.Constants;

import com.fasterxml.jackson.annotation.JsonProperty;

public class RosterUser extends AbstractRenkanColoredModel<String> {

    private String projectId;
    private Long siteId;
    private String clientId;

    public RosterUser(String id, String title, String description, String uri,
            String color, String project_id, Long site_id, String client_id) {
        super(id, title, description, uri, color);

        if(this.id == null) {
            this.id = Constants.UUID_GENERATOR.generate().toString();
        }
        this.projectId = project_id;
        this.siteId = site_id;
        this.clientId = client_id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setColor(String color) {
        this.color = color;
    }

    @JsonProperty(value = "project_id")
    public String getProjectId() {
        return projectId;
    }

    @JsonProperty(value = "site_id")
    public Long getSiteId() {
        return siteId;
    }

    @JsonProperty(value = "client_id")
    public String getClientId() {
        return clientId;
    }

    @Override
    protected String getRawKeyPart() {
        return this.id;
    }
    
    @Override
    protected String getDefaultId() {
        return UUID.randomUUID().toString();
    }

}
