package org.iri_research.renkan.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.iri_research.renkan.models.Project;
import org.iri_research.renkan.models.Space;
import org.iri_research.renkan.repositories.ProjectsRepository;
import org.iri_research.renkan.repositories.SpacesRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.servlet.ModelAndView;


@Controller
@RequestMapping("/")
public class RenkanRootController {

	private final Logger logger = LoggerFactory.getLogger(RenkanRootController.class);
		
	@Autowired
	private ProjectsRepository projectsRepository;
	
	@Autowired
	private SpacesRepository spacesRepository;
		
	@RequestMapping(value="", method = RequestMethod.GET, produces={"text/html;charset=UTF-8"})
	public ModelAndView renkanIndex() {
				
		Map<String, Object> model = new HashMap<String, Object>();
		
		Iterable<Space> spaces = this.spacesRepository.findAll();
		
		model.put("spaces", spaces);
		
		return new ModelAndView("renkanIndex", model);
	}

	@RequestMapping(value="/s/{space_id}", method = RequestMethod.GET, produces={"text/html;charset=UTF-8"})
	public ModelAndView spaceIndex(@PathVariable("space_id") String spaceId) {
		
		logger.debug("SpaceId : " + (spaceId== null ? "null" : spaceId));
		
		Map<String, Object> model = new HashMap<String, Object>();

		if("_".equals(spaceId)) {
			spaceId = null;
		}
		
		Space space = this.spacesRepository.findOne(spaceId);
		
		if(null == space) {
			throw new HttpClientErrorException(HttpStatus.NOT_FOUND, "Space " + spaceId + " not found.");
		}
		
		model.put("space", space);
		
		List<Project> projects = this.projectsRepository.findBySpaceId(spaceId);
		
		model.put("projects", projects);
		
		return new ModelAndView("projectIndex", model);
	}
	
		
}
