/*
 * Decompiled with CFR 0.152.
 */
package org.coweb.admin.acls;

public class SessionAcls {
    public static final int SESS_SEE_BIT = 1;
    public static final int SESS_ACCESS_BIT = 2;
    public static final int SESS_CONTROL_BIT = 4;
    public static final int SESS_CHANGE_BIT = 8;
    public static final int SESS_ALL = 15;
    public static final int ROLE_UNINVITED = 1;
    public static final int ROLE_GUEST = 3;
    public static final int ROLE_PARTICIPANT = 7;
    public static final int ROLE_MODERATOR = 15;
    public static final int SESS_PRIVACY_PRIVATE = 0;
    public static final int SESS_PRIVACY_PUBLIC = 1;
    public static final int SESS_PRIVACY_INVITE = 2;
    public static final int SESS_PRIVACY_CUSTOM = 127;
    public static final int SESS_ACTIVITY_ANYTIME = 0;
    public static final int SESS_ACTIVITY_ACTIVE = 1;
    private int bits = 0;

    public SessionAcls(int bits) {
        this.bits = bits;
    }

    public void setAll() {
        this.bits = 15;
    }

    public int getAcls() {
        return this.bits;
    }

    public boolean canSeeSession() {
        return SessionAcls.valueOf(this.bits & 1);
    }

    public void setSeeSession(boolean value) {
        this.bits = value ? (this.bits |= 1) : (this.bits &= 0xFFFFFFFE);
    }

    public boolean canAccessSession() {
        return SessionAcls.valueOf(this.bits & 2);
    }

    public void setAccessSession(boolean value) {
        this.bits = value ? (this.bits |= 2) : (this.bits &= 0xFFFFFFFD);
    }

    public boolean canControlSession(boolean value) {
        this.bits = value ? (this.bits |= 4) : (this.bits &= 0xFFFFFFFB);
        return SessionAcls.valueOf(this.bits & 4);
    }

    public boolean canChangeSession(boolean value) {
        this.bits = value ? (this.bits |= 8) : (this.bits &= 0xFFFFFFF7);
        return SessionAcls.valueOf(this.bits & 8);
    }

    private static boolean valueOf(int i) {
        return i != 0;
    }
}

