
define([], function () {
    'use strict';

    var cloud_path = "M0,0c-0.1218516546,-0.0336420601 -0.2451649928,0.0048580836 -0.3302944641,0.0884969975c-0.0444763883,-0.0550844815 -0.1047003238,-0.0975985034 -0.1769360893,-0.1175406746c-0.1859066673,-0.0513257002 -0.3774236254,0.0626045858 -0.4272374613,0.2541588105c-0.0036603877,0.0140753132 -0.0046241235,0.028229722 -0.0065872453,0.042307536c-0.1674179627,-0.0179317735 -0.3276106855,0.0900599386 -0.3725537463,0.2628868425c-0.0445325077,0.1712456429 0.0395025693,0.3463497959 0.1905420475,0.4183458793c-0.0082101538,0.0183442886 -0.0158652506,0.0372432828 -0.0211098452,0.0574080693c-0.0498130336,0.1915540431 0.0608692569,0.3884647499 0.2467762814,0.4397904033c0.0910577256,0.0251434257 0.1830791813,0.0103792696 0.2594677475,-0.0334472349c0.042100113,0.0928009202 0.1205930075,0.1674914182 0.2240666796,0.1960572479c0.1476344161,0.0407610407 0.297446165,-0.0238077445 0.3783262342,-0.1475652419c0.0327623278,0.0238981846 0.0691792333,0.0436665447 0.1102008706,0.0549940004c0.1859065794,0.0513256592 0.3770116432,-0.0627203154 0.4268255671,-0.2542745401c0.0250490557,-0.0963230532 0.0095494076,-0.1938010889 -0.0356681889,-0.2736906101c0.0447507424,-0.0439678867 0.0797796014,-0.0996624318 0.0969425462,-0.1656617192c0.0498137481,-0.1915564561 -0.0608688118,-0.3884669813 -0.2467755669,-0.4397928163c-0.0195699622,-0.0054005426 -0.0391731675,-0.0084429542 -0.0586916488,-0.0102888295c0.0115683912,-0.1682147574 -0.0933564223,-0.3269222408 -0.2572937178,-0.3721841203z";
    /* ShapeBuilder Begin */

    var builders = {
        "circle":{
            getShape: function() {
                return new paper.Path.Circle([0, 0], 1);
            },
            getImageShape: function(center, radius) {
                return new paper.Path.Circle(center, radius);
            }
        },
        "rectangle":{
            getShape: function() {
                return new paper.Path.Rectangle([-2, -2], [2, 2]);
            },
            getImageShape: function(center, radius) {
                return new paper.Path.Rectangle([-radius, -radius], [radius*2, radius*2]);
            }
        },
        "ellipse":{
            getShape: function() {
                return new paper.Path.Ellipse(new paper.Rectangle([-2, -1], [2, 1]));
            },
            getImageShape: function(center, radius) {
                return new paper.Path.Ellipse(new paper.Rectangle([-radius, -radius/2], [radius*2, radius]));
            }
        },
        "polygon":{
            getShape: function() {
                return new paper.Path.RegularPolygon([0, 0], 6, 1);
            },
            getImageShape: function(center, radius) {
                return new paper.Path.RegularPolygon(center, 6, radius);
            }
        },
        "diamond":{
            getShape: function() {
                var d = new paper.Path.Rectangle([-Math.SQRT2, -Math.SQRT2], [Math.SQRT2, Math.SQRT2]);
                d.rotate(45);
                return d;
            },
            getImageShape: function(center, radius) {
                var d = new paper.Path.Rectangle([-radius*Math.SQRT2/2, -radius*Math.SQRT2/2], [radius*Math.SQRT2, radius*Math.SQRT2]);
                d.rotate(45);
                return d;
            }
        },
        "star":{
            getShape: function() {
                return new paper.Path.Star([0, 0], 8, 1, 0.7);
            },
            getImageShape: function(center, radius) {
                return new paper.Path.Star(center, 8, radius*1, radius*0.7);
            }
        },
        "cloud": {
            getShape: function() {
                var path = new paper.Path(cloud_path);
                return path;

            },
            getImageShape: function(center, radius) {
                var path = new paper.Path(cloud_path);
                path.scale(radius);
                path.translate(center);
                return path;
            }
        },
        "triangle": {
            getShape: function() {
                return new paper.Path.RegularPolygon([0,0], 3, 1);
            },
            getImageShape: function(center, radius) {
                return new paper.Path.RegularPolygon(center, 3, radius);
            }
        },
        "svg": function(path){
            return {
                getShape: function() {
                    return new paper.Path(path);
                },
                getImageShape: function(center, radius) {
                    // No calcul for the moment
                    return new paper.Path();
                }
            };
        }
    };

    var ShapeBuilder = function (shape){
        if(shape === null || typeof shape === "undefined"){
            shape = "circle";
        }
        if(shape.substr(0,4)==="svg:"){
            return builders.svg(shape.substr(4));
        }
        if(!(shape in builders)){
            shape = "circle";
        }
        return builders[shape];
    };

    ShapeBuilder.builders = builders;

    return ShapeBuilder;

});
