(function(root) {

    "use strict";

    var DataLoader = root.Rkns.DataLoader = {
        converters: {
            from1to2: function(data) {

                var i, len;
                if(typeof data.nodes !== 'undefined') {
                    for(i=0, len=data.nodes.length; i<len; i++) {
                        var node = data.nodes[i];
                        if(node.color) {
                            console.log("node color : ", node.color);
                            node.style = {
                                color: node.color,
                            };
                        }
                        else {
                            node.style = {};
                        }
                    }
                }
                if(typeof data.edges !== 'undefined') {
                    for(i=0, len=data.edges.length; i<len; i++) {
                        var edge = data.edges[i];
                        if(edge.color) {
                            edge.style = {
                                color: edge.color,
                            };
                        }
                        else {
                            edge.style = {};
                        }
                    }
                }

                data.schema_version = "2";

                return data;
            },
        }
    };


    DataLoader.Loader = function(project, options) {
        this.project = project;
        this.dataConverters = _.defaults(options.converters || {}, DataLoader.converters);
    };


    DataLoader.Loader.prototype.convert = function(data) {
        var schemaVersionFrom = this.project.getSchemaVersion(data);
        var schemaVersionTo = this.project.getSchemaVersion();

        if (schemaVersionFrom !== schemaVersionTo) {
            var converterName = "from" + schemaVersionFrom + "to" + schemaVersionTo;
            if (typeof this.dataConverters[converterName] === 'function') {
                console.log("Apply conversion function :", converterName);
                data = this.dataConverters[converterName](data);
            }
        }
        return data;
    };

    DataLoader.Loader.prototype.load = function(data) {
        console.log(data);
        this.project.set(this.convert(data), {
            validate: true
        });
    };

})(window);
