Rkns.RemoteModels.RandomData = Rkns.Utils.inherit(Rkns.RemoteModels._Base);

Rkns.RemoteModels.RandomData.prototype._init = function() {
    this._USER_COUNT = 5;
    this._NODE_COUNT = 20;
    this._EDGE_COUNT = 40;
    this.user_colors = ["#1f77b4","#aec7e8","#ff7f0e","#ffbb78","#2ca02c","#98df8a","#d62728","#ff9896","#9467bd","#c5b0d5","#8c564b","#c49c94","#e377c2","#f7b6d2","#7f7f7f","#c7c7c7","#bcbd22","#dbdb8d","#17becf","#9edae5"];
    this.load();
}

Rkns.RemoteModels.RandomData.prototype.load = function() {
    var _p = this._project;
    _p.title = "Random Generated Data";
    for (var i = 0; i < this._USER_COUNT; i++) {
        _p.users.push(new Rkns.ViewModel.User(_p, {
            id: "user-"+i,
            title: "User #"+(1+i),
            color: this.user_colors[i]
        }));
    }
    for (var i = 0; i < this._NODE_COUNT; i++) {
        _p.nodes.push(new Rkns.ViewModel.Node(_p, {
            id: "node-"+i,
            title: "Node #"+(1+i),
            created_by: "user-" + Math.floor(this._USER_COUNT*Math.random()),
            position: {
//                x: 200 * Math.random(),
//                y: 150 * Math.random()
                x: 100 * Math.cos(2 * Math.PI * i / this._NODE_COUNT),
                y: 100 * Math.sin(2 * Math.PI * i / this._NODE_COUNT)
            }
        }));
    }
    for (var i = 0; i < this._EDGE_COUNT; i++) {
        var _from, _to;
        _from = _to = Math.floor(this._NODE_COUNT*Math.random());
        while(_from === _to) {
            _to = Math.floor(this._NODE_COUNT*Math.random());
        }
        _p.edges.push(new Rkns.ViewModel.Edge(_p, {
            id: "edge-"+i,
            title: "Edge #"+(1+i),
            created_by: "user-" + Math.floor(this._USER_COUNT*Math.random()),
            from: "node-" + _from,
            to: "node-" + _to
        }));
    }
    this.handleCallbacks();
}
