/* 
 *  Copyright 2012 Institut de recherche et d'innovation 
 *  contributor(s) : Samuel Huron, Raphael Velt
 *   
 *  contact@iri.centrepompidou.fr
 *  http://www.iri.centrepompidou.fr 
 *   
 *  This software is a computer program whose purpose is to show and add annotations on a video .
 *  This software is governed by the CeCILL-C license under French law and
 *  abiding by the rules of distribution of free software. You can  use, 
 *  modify and/ or redistribute the software under the terms of the CeCILL-C
 *  license as circulated by CEA, CNRS and INRIA at the following URL
 *  "http://www.cecill.info". 
 *  
 *  The fact that you are presently reading this means that you have had
 *  knowledge of the CeCILL-C license and that you accept its terms.
*/

/* Declaring the Renkan Namespace Rkns and Default values */

Rkns = {
    _MIN_DRAG_DISTANCE: 2,
    _NODE_RADIUS: 20,
    _NODE_FONT_SIZE: 14,
    _ARROW_LENGTH: 20,
    _ARROW_WIDTH: 15,
    _RENDER: 1,
    _SAVE: 2,
    _RENDER_AND_SAVE: 3
}

Rkns.$ = jQuery;

Rkns._ = _;

Rkns.RemoteModels = {};

Rkns.RemoteModels._Base = function(_project, _opts) {
    if (typeof _project !== "undefined") {
        this._project = _project;
        this._callbackQueue = [];
        this._loaded = false;
    }
}

Rkns.RemoteModels._Base.prototype.fullSave
    = Rkns.RemoteModels._Base.prototype.addUser
    = Rkns.RemoteModels._Base.prototype.addNode
    = Rkns.RemoteModels._Base.prototype.addEdge
    = Rkns.RemoteModels._Base.prototype.updateNode
    = Rkns.RemoteModels._Base.prototype.updateEdge
    = Rkns.RemoteModels._Base.prototype.removeNode
    = Rkns.RemoteModels._Base.prototype.removeEdge
    = function() {}

Rkns.RemoteModels._Base.prototype.deferCallback = function(_callback) {
    var _this = this;
    Rkns._.defer(function() {
        _callback.call(_this);
    });
}

Rkns.RemoteModels._Base.prototype.handleCallbacks = function() {
    this._loaded = true;
    while (this._callbackQueue.length) {
        this.deferCallback(this._callbackQueue.splice(0,1)[0]);
    }
}

Rkns.RemoteModels._Base.prototype.onLoad = function(_callback) {
    if (this._loaded) {
        this.deferCallback(_callback);
    } else {
        this._callbackQueue.push(_callback);
    }
}

Rkns.RemoteModels._Base.prototype.save = function() {}

Rkns.Bins = {}

Rkns.Bins._Base = function(_project) {
    if (typeof _project !== "undefined") {
        this._project = _project;
    }
}

Rkns.Bins._Base.prototype.baseTemplate = '';

Rkns.Bins._Base.prototype.addTab = function(_title) {
    var _tabDiv = Rkns.$('<div>');
    _tabDiv.addClass('Rk-TabDiv')
        .css("display","none")
        .appendTo('.Rk-TabDivs');
    var _tabButton = Rkns.$('<li>');
    _tabButton.addClass('Rk-TabButton')
        .html(_title)
        .click(function() {
            Rkns.$('.Rk-TabButton').removeClass("active");
            Rkns.$(this).addClass("active");
            Rkns.$('.Rk-TabDiv').hide();
            _tabDiv.show();
        })
        .appendTo('.Rk-TabButtons');
    return {
        button: _tabButton,
        contents: _tabDiv
    }
}

/* Point of entry */

Rkns.Renkan = function(_opts) {
    if (typeof _opts.remotemodel == "undefined") {
        _opts.remotemodel = "BasicJson";
    }
    if (typeof _opts.language == "undefined" || typeof Rkns.i18n[_opts.language] == "undefined") {
        _opts.language = "en";
    }
    if (typeof _opts.container == "undefined") {
        _opts.container = "renkan";
    }
    this.project = new Rkns.ViewModel.Project();
    this.project.l10n = Rkns.i18n[_opts.language];
    if (typeof _opts.user === "object") {
        this.current_user = this.project.addUser(_opts.user)
    }
    Rkns.$("#" + _opts.container).html(this.template());
    this.project.remotemodel = new Rkns.RemoteModels[_opts.remotemodel](this.project, _opts);
    this.project.renderer = new Rkns.Renderer.Scene(this.project, _opts);
    var _this = this;
/*    if (typeof _opts.bins === "object") {
        this.bins = Rkns._(_opts.bins).map(function(_type) {
            return new Rkns.Bins[_type](_this);
        });
        Rkns.$('.Rk-TabButton:last').addClass("active");
        Rkns.$('.Rk-TabDiv:last').show();
} */
    this.project.remotemodel.onLoad(function() {
        if (typeof _this.project.current_user === "undefined") {
            _this.project.current_user = _this.project.users[0];
        }
        _this.project.renderer.draw();
    });
}

Rkns.Renkan.prototype.template = Rkns._.template(
    '<div class="Rk-Bins"></div><div class="Rk-Render"></div>'
);

/* Utility functions */

Rkns.Utils = {
    _ID_AUTO_INCREMENT : 0,
    _ID_BASE : (function(_d) {
        function pad(n){return n<10 ? '0'+n : n}
        function fillrand(n) {
            var _res = ''
            for (var i=0; i<n; i++) {
                _res += Math.floor(16*Math.random()).toString(16);
            }
            return _res;
        }
        return _d.getUTCFullYear() + '-'  
            + pad(_d.getUTCMonth()+1) + '-'  
            + pad(_d.getUTCDate()) + '-'
            + fillrand(16);
    })(new Date()),
    getUID : function(_base) {
        var _n = (++this._ID_AUTO_INCREMENT).toString(16),
            _base = (typeof _base === "undefined" ? "" : _base + "-" );
        while (_n.length < 4) {
            _n = '0' + _n
        }
        return _base + this._ID_BASE + '-' + _n;
    },
    inherit : function(_baseClass, _callbefore) {
        var _class = function() {
            if (typeof _callbefore === "function") {
                _callbefore.apply(this, Array.prototype.slice.call(arguments, 0));
            }
            if (typeof _baseClass.prototype._init !== "function") {
                _baseClass.prototype._init = function() {}
            }
            _baseClass.apply(this, Array.prototype.slice.call(arguments, 0));
            this._init.apply(this, Array.prototype.slice.call(arguments, 0));
        }
        _class.prototype = new _baseClass();
        return _class;
    }
}