package org.iri_research.renkan.models;

import java.io.Serializable;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRenkanColoredModel<ID extends Serializable> extends AbstractRenkanModel<ID> implements IRenkanColoredModel<ID> {
    
    @SuppressWarnings("unused")
    private static Logger logger = LoggerFactory.getLogger(AbstractRenkanColoredModel.class);

    public AbstractRenkanColoredModel(ID id, String title, String description,
            String uri, String color) {
        super(id, title, description, uri);
        this.color = color;
    }

    protected AbstractRenkanColoredModel() {
        
    }
    
    protected String color;
    
    @Override
    public String getColor() {
        return this.color;
    }
    
    @Override
    public void setColor(String color) {
        this.color = color;
    }


}
