/*
 * Decompiled with CFR 0.152.
 */
package org.coweb.bots.transport;

import java.io.IOException;
import java.util.Map;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerSession;
import org.coweb.SessionManager;

public abstract class Transport {
    protected Map<String, Object> botConfig = null;
    protected String serviceName = null;
    protected String sessionId = null;
    protected BayeuxServer bayeuxServer = null;
    protected ServerSession server = null;

    protected Transport() {
        SessionManager manager = SessionManager.getInstance();
        this.bayeuxServer = manager.getBayeux();
        this.server = manager.getServerSession();
    }

    public Transport(Map<String, Object> botConfig, String sessionId) {
        this.botConfig = botConfig;
        this.sessionId = sessionId;
    }

    public void setBotConfig(Map<String, Object> botConfig) {
        this.botConfig = botConfig;
        this.serviceName = (String)botConfig.get("service");
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ServerSession getServer() {
        return this.server;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setBayeuxServer(BayeuxServer bayeuxServer) {
        this.bayeuxServer = bayeuxServer;
    }

    public ServerChannel getResponseChannel() {
        String channelName = "/bot/" + this.serviceName;
        ServerChannel serverChannel = this.bayeuxServer.getChannel(channelName);
        if (serverChannel != null) {
            return serverChannel;
        }
        ConfigurableServerChannel.Initializer initializer = new ConfigurableServerChannel.Initializer(){

            public void configureChannel(ConfigurableServerChannel channel) {
                channel.setPersistent(true);
                channel.setLazy(false);
            }
        };
        this.bayeuxServer.createIfAbsent(channelName, new ConfigurableServerChannel.Initializer[]{initializer});
        return this.bayeuxServer.getChannel(channelName);
    }

    public abstract void init();

    public abstract boolean subscribeUser(ServerSession var1, boolean var2) throws IOException;

    public abstract boolean unsubscribeUser(ServerSession var1, boolean var2) throws IOException;

    public abstract boolean userRequest(ServerSession var1, Message var2) throws IOException;

    public abstract void shutdown();
}

