/* Defines the View Model */

Rkns.ViewModel = {}

/* Project Class */

Rkns.ViewModel.Project = function() {
    this.users = new Rkns.ViewModel.List();
    this.nodes = new Rkns.ViewModel.List();
    this.edges = new Rkns.ViewModel.List();
}

Rkns.ViewModel.Project.prototype.addNode = function(_props, _render_save) {
    var _node = new Rkns.ViewModel.Node(this, _props);
    this.nodes.push(_node);
    if (typeof _render_save !== "undefined" && (_render_save&Rkns._RENDER)) {
        var _controller = this.renderer.addController("Node", _node);
        _controller.redraw();
    }
    if (typeof _render_save !== "undefined" && (_render_save&Rkns._SAVE)) {
        this.remotemodel.addNode(_node);
    }
    return _node;
}

Rkns.ViewModel.Project.prototype.addEdge = function(_props, _render_save) {
    var _edge = new Rkns.ViewModel.Edge(this, _props);
    this.edges.push(_edge);
    if (typeof _render_save !== "undefined" && (_render_save&Rkns._RENDER)) {
        var _controller = this.renderer.addController("Edge", _edge);
        _controller.redraw();
    }
    if (typeof _render_save !== "undefined" && (_render_save&Rkns._SAVE)) {
        this.remotemodel.addEdge(_edge);
    }
    return _edge;
}

Rkns.ViewModel.Project.prototype.addUser = function(_props, _render_save) {
    var _user = new Rkns.ViewModel.User(this, _props);
    this.users.push(_user);
    if (typeof _render_save !== "undefined" && (_render_save&Rkns._SAVE)) {
        this.remotemodel.addUser(_user);
    }
    return _user;
}


Rkns.ViewModel.Project.prototype.updateNode = function(_element, _props, _render_save) {
    this.updateElement("Node", _element, _props, _render_save)
}

Rkns.ViewModel.Project.prototype.updateEdge = function(_element, _props, _render_save) {
    this.updateElement("Edge", _element, _props, _render_save)
}

Rkns.ViewModel.Project.prototype.updateElement = function(_type, _element, _props, _render_save) {
    Rkns._(_props).each(function(_v, _k) {
        _element[_k] = _v;
    });
    if (typeof _render_save !== "undefined" && (_render_save&Rkns._RENDER)) {
        if (typeof _element.__controller !== "undefined") {
            _element.__controller.redraw();
        } else {
            this._renderer.redraw();
        }
    }
    if (typeof _render_save !== "undefined" && (_render_save&Rkns._SAVE)) {
        this.remotemodel[ "update" + _type ](_element);
    }
}

Rkns.ViewModel.Project.prototype.removeNode = function(_node, _render_save) {
    this.nodes.removeId(_node.id);
    if (typeof _node.__controller !== "undefined") {
        this.renderer.removeController(_node.__controller);
    }
    var _this = this;
    this.edges = this.edges.filter(function(_edge) {
        var _keep = _edge.from !== _node && _edge.to !== _node;
        if (!_keep && typeof _edge.__controller !== "undefined") {
            _this.renderer.removeController(_edge.__controller);
        }
        return _keep;
    });
    if (typeof _render_save !== "undefined" && (_render_save&Rkns._RENDER)) {
        this.renderer.redraw();
    }
    if (typeof _render_save !== "undefined" && (_render_save&Rkns._SAVE)) {
        this.remotemodel.removeNode(_node.id);
    }
    return _node;
}

Rkns.ViewModel.Project.prototype.removeEdge = function(_edge, _render_save) {
    this.edges.removeId(_edge.id);
    if (typeof _edge.__controller !== "undefined") {
        this.renderer.removeController(_edge.__controller);
    }
    if (typeof _render_save !== "undefined" && (_render_save&Rkns._RENDER)) {
        this.renderer.redraw();
    }
    if (typeof _render_save !== "undefined" && (_render_save&Rkns._SAVE)) {
        this.remotemodel.removeEdge(_edge.id);
    }
    return _edge;
}

/* Base Element */

Rkns.ViewModel._BaseElement = function(_project, _props) {
    if (typeof _props !== "undefined") {
        this._project = _project;
        this.id = _props.id || Rkns.Utils.getUID(this.type);
        this.title = _props.title || "(untitled " + this.type + ")";
        this.description = _props.description || "";
        this.uri = _props.uri || "";
    }
}

Rkns.ViewModel._BaseElement.prototype.addReference = function(_propName, _list, _id, _default) {
    var _element = _list.getElement(_id);
    if (typeof _element === "undefined" && typeof _default !== "undefined") {
        this[ _propName ] = _default;
        this[ _propName + "_id" ] = _default.id;
    } else {
        this[ _propName + "_id" ] = _id;
        this[ _propName ] = _element;
    }
}

Rkns.ViewModel._BaseElement.prototype.updateGraphics = function() {
    this._project.renderer.redraw();
}

Rkns.ViewModel._BaseElement.prototype.updateData = function() {
    this._project.remotemodel.save(this);
}

/* Element Class Generator */

Rkns.ViewModel._elementClass = function(_type) {
    return Rkns.Utils.inherit(Rkns.ViewModel._BaseElement, function() {
        this.type = _type;
    });
}

/* User Model */

Rkns.ViewModel.User = Rkns.ViewModel._elementClass("user");

Rkns.ViewModel.User.prototype._init = function(_project, _props) {
    this.color = _props.color || "#666666";
}

/* Node Model */

Rkns.ViewModel.Node = Rkns.ViewModel._elementClass("node");

Rkns.ViewModel.Node.prototype._init = function(_project, _props) {
    this.addReference("created_by", this._project.users, _props.created_by, _project.current_user);
    this.position = _props.position;
    this.description = _props.description || "";
}

Rkns.ViewModel.Node.prototype.setPosition = function(_x, _y) {
    if (typeof _x === "object") {
        if (typeof _x.x !== "undefined" && typeof _x.y !== "undefined") {
            this.position.x = _x.x;
            this.position.y = _x.y;
        } else {
            if (typeof _x.length !== "undefined") {
                this.position.x = _x[0];
                this.position.y = _x[1];
            }
        }
    } else {
        if (typeof _y !== "undefined") {
            this.position.x = +_x;
            this.position.y = +_y;
        }
    }
}

/* Edge Model */

Rkns.ViewModel.Edge = Rkns.ViewModel._elementClass("edge");

Rkns.ViewModel.Edge.prototype._init = function(_project, _props) {
    this.addReference("created_by", this._project.users, _props.created_by, _project.current_user);
    this.addReference("from", this._project.nodes, _props.from);
    this.addReference("to", this._project.nodes, _props.to);
}

/* List Helper Functions -- See Metadataplayer */

Rkns.ViewModel.List = function() {
    Array.call(this);
    this.idIndex = [];
}

Rkns.ViewModel.List.prototype = new Array();

Rkns.ViewModel.List.prototype.hasId = function(_id) {
    return Rkns._(this.idIndex).include(_id);
}

Rkns.ViewModel.List.prototype.getIds = function(_id) {
    return this.idIndex;
}

/* On recent browsers, forEach and map are defined and do what we want.
 * Otherwise, we'll use the Underscore.js functions
 */
if (typeof Array.prototype.forEach === "undefined") {
    Rkns.ViewModel.List.prototype.forEach = function(_callback) {
        var _this = this;
        Rkns._(this).forEach(function(_value, _key) {
            _callback(_value, _key, _this);
        });
    }
}

if (typeof Array.prototype.map === "undefined") {
    Rkns.ViewModel.List.prototype.map = function(_callback) {
        var _this = this;
        return Rkns._(this).map(function(_value, _key) {
            return _callback(_value, _key, _this);
        });
    }
}

/* We override Array's filter function because it doesn't return an Rkns.ViewModel.List
 */
Rkns.ViewModel.List.prototype.filter = function(_callback) {
    var _this = this,
        _res = new Rkns.ViewModel.List();
    _res.addElements(Rkns._(this).filter(function(_value, _key) {
        return _callback(_value, _key, _this);
    }));
    return _res;
}

Rkns.ViewModel.List.prototype.slice = function(_start, _end) {
    var _res = new Rkns.ViewModel.List();
    _res.addElements(Array.prototype.slice.call(this, _start, _end));
    return _res;
}

Rkns.ViewModel.List.prototype.splice = function(_start, _end) {
    var _res = new Rkns.ViewModel.List();
    _res.addElements(Array.prototype.splice.call(this, _start, _end));
    this.idIndex.splice(_start, _end);
    return _res;
}

/* Array has a sort function, but it's not as interesting as Underscore.js's sortBy
 * and won't return a new Rkns.ViewModel.List
 */
Rkns.ViewModel.List.prototype.sortBy = function(_callback) {
    var _this = this,
        _res = new Rkns.ViewModel.List();
    _res.addElements(Rkns._(this).sortBy(function(_value, _key) {
        return _callback(_value, _key, _this);
    }));
    return _res;
}

Rkns.ViewModel.List.prototype.push = function(_el) {
    if (typeof _el === "undefined" || typeof _el.id === "undefined") {
        return;
    }
    var _index = (Rkns._(this.idIndex).indexOf(_el.id));
    if (_index === -1) {
        this.idIndex.push(_el.id);
        Array.prototype.push.call(this, _el);
    } else {
        this[_index] = _el;
    }
}

Rkns.ViewModel.List.prototype.addElements = function(_array) {
    var _this = this;
    Rkns._(_array).forEach(function(_el) {
        _this.push(_el);
    });
}

Rkns.ViewModel.List.prototype.removeId = function(_id) {
    var _index = (Rkns._(this.idIndex).indexOf(_id));
    if (_index !== -1) {
        this.splice(_index,1);
    }
}

Rkns.ViewModel.List.prototype.removeIds = function(_list) {
    var _this = this;
    Rkns._(_list).forEach(function(_id) {
        _this.removeId(_id);
    });
}

Rkns.ViewModel.List.prototype.getElement = function(_id) {
    var _index = Rkns._(this.idIndex).indexOf(_id);
    if (_index === -1) {
        return undefined;
    } else {
        return this[_index];
    }
}
