/* Saves the Full JSON at each modification */

Rkns.RemoteModels.FullJson = Rkns.Utils.inherit(Rkns.RemoteModels._Base);

Rkns.RemoteModels.FullJson.prototype._init = function(_project, _opts) {
    this.url = _opts.url;
    this.load(this.url);
    if (typeof _opts.http_method == "undefined") {
        _opts.http_method = 'PUT';
    }
    this.http_method = _opts.http_method;
    var _this = this;
    this.fullSave
        = this.addUser
        = this.addNode
        = this.addEdge
        = this.updateNode
        = this.updateEdge
        = this.removeNode
        = this.removeEdge
        = Rkns._.throttle(function() {
            _this._save.apply(this, Array.prototype.slice.call(arguments,0));
        }, 2000);
}

Rkns.RemoteModels.FullJson.prototype.load = function(_url) {
    var _this = this;
    Rkns.$.getJSON(_url, function(_data) {
        _this.deserialize(_data);
        _this.handleCallbacks();
    });
}

Rkns.RemoteModels.FullJson.prototype.deserialize = function(_serializedData) {
    if (typeof _serializedData === "string") {
        _serializedData = JSON.parse(_serializedData);
    }
    var _proj = this._project;
    _proj.title = _serializedData.title || "(untitled project)";
    if (typeof _serializedData.users === "object" && _serializedData.users) {
        Rkns._(_serializedData.users).each(function(_data) {
            var _userData = {
                id: _data.id,
                title: _data.title,
                uri: _data.uri,
                color: _data.color
            };
            _proj.addUser(_userData);
        });
    }
    if (typeof _serializedData.nodes === "object" && _serializedData.nodes) {
        Rkns._(_serializedData.nodes).each(function(_data) {
            var _nodeData = {
                id: _data.id,
                title: _data.title,
                description: _data.description,
                uri: _data.uri,
                created_by: _data.created_by,
                position: {
                    x: _data.position.x,
                    y: _data.position.y
                }
            };
            _proj.addNode(_nodeData);
        });
    }
    if (typeof _serializedData.edges === "object" && _serializedData.edges) {
        Rkns._(_serializedData.edges).each(function(_data) {
            var _edgeData = {
                id: _data.id,
                title: _data.title,
                uri: _data.uri,
                from: _data.from,
                to: _data.to,
                created_by: _data.created_by
            };
            _proj.addEdge(_edgeData);
        });
    }
}

Rkns.RemoteModels.FullJson.prototype.serialize = function() {
    var _res = {
        title: this._project.title,
        users: this._project.users.map(function(_user) {
            return {
                id: _user.id,
                title: _user.title,
                uri: _user.uri,
                color: _user.color
            }
        }),
        nodes: this._project.nodes.map(function(_node) {
            return {
                id: _node.id,
                title: _node.title,
                description: _node.description,
                uri: _node.uri,
                created_by: _node.created_by.id,
                position: {
                    x: _node.position.x,
                    y: _node.position.y
                }
            }
        }),
        edges: this._project.edges.map(function(_edge) {
            return {
                id: _edge.id,
                title: _edge.title,
                uri: _edge.uri,
                from: _edge.from.id,
                to: _edge.to.id,
                created_by: _edge.created_by.id
            }
        })
    }
    return _res;
}

Rkns.RemoteModels.FullJson.prototype._save = function() {
    var _data = JSON.stringify(this.serialize());
    Rkns.$.ajax({
    	type: this.http_method,
    	url: this.url,
    	contentType: "application/json",
    	data: _data,
    	success: function(data, textStatus, jqXHR) {
        }
    });
};
