/* 
 *  Copyright 2012 Institut de recherche et d'innovation 
 *  contributor(s) : Samuel Huron, Raphael Velt
 *   
 *  contact@iri.centrepompidou.fr
 *  http://www.iri.centrepompidou.fr 
 *   
 *  This software is a computer program whose purpose is to show and add annotations on a video .
 *  This software is governed by the CeCILL-C license under French law and
 *  abiding by the rules of distribution of free software. You can  use, 
 *  modify and/ or redistribute the software under the terms of the CeCILL-C
 *  license as circulated by CEA, CNRS and INRIA at the following URL
 *  "http://www.cecill.info". 
 *  
 *  The fact that you are presently reading this means that you have had
 *  knowledge of the CeCILL-C license and that you accept its terms.
*/

/* Declaring the Renkan Namespace Rkns and Default values */

Rkns = {
    _MIN_DRAG_DISTANCE: 4,
    _NODE_RADIUS: 20,
    _NODE_FONT_SIZE: 14,
    _ARROW_LENGTH: 20,
    _ARROW_WIDTH: 15,
    _RENDER: 1,
    _SAVE: 2,
    _RENDER_AND_SAVE: 3
}

Rkns.$ = jQuery;

Rkns._ = _;

Rkns.Serializers = {};

Rkns.Serializers._Base = function(_project) {
    if (typeof _project !== "undefined") {
        this._project = _project;
        this._callbackQueue = [];
        this._loaded = false;
    }
}

Rkns.Serializers._Base.prototype.deserialize = function() {}

Rkns.Serializers._Base.prototype.deferCallback = function(_callback) {
    var _this = this;
    Rkns._.defer(function() {
        _callback.call(_this);
    });
}

Rkns.Serializers._Base.prototype.handleCallbacks = function() {
    this._loaded = true;
    while (this._callbackQueue.length) {
        this.deferCallback(this._callbackQueue.splice(0,1)[0]);
    }
}

Rkns.Serializers._Base.prototype.onLoad = function(_callback) {
    if (this._loaded) {
        this.deferCallback(_callback);
    } else {
        this._callbackQueue.push(_callback);
    }
}

Rkns.Serializers._Base.prototype.save = function() {}

Rkns.Project = function(_opts) {
    if (typeof _opts.serializer == "undefined") {
        _opts.serializer = "BasicJson";
    }
    if (typeof _opts.language == "undefined" || typeof Rkns.i18n[_opts.language] == "undefined") {
        _opts.language = "en";
    }
    this.l10n = Rkns.i18n[_opts.language];
    this._opts = _opts;
    this.users = new Rkns.Model.List();
    this.nodes = new Rkns.Model.List();
    this.edges = new Rkns.Model.List();
    if (typeof this._opts.user === "object") {
        this.current_user = this.addUser(this._opts.user)
    }
    this.serializer = new Rkns.Serializers[_opts.serializer](this);
    this.renderer = new Rkns.Renderer.Scene(this);
    var _this = this;
    this.serializer.onLoad(function() {
        if (typeof _this.current_user === "undefined") {
            _this.current_user = _proj.users[0];
        }
        _this.renderer.draw();
    });
}

Rkns.Project.prototype.addNode = function(_props, _render_save) {
    var _node = new Rkns.Model.Node(this, _props);
    this.nodes.push(_node);
    if (typeof _render_save !== "undefined" && (_render_save&Rkns._RENDER)) {
        var _controller = this.renderer.addController("Node", _node);
        _controller.redraw();
    }
    if (typeof _render_save !== "undefined" && (_render_save&Rkns._SAVE)) {
        this.serializer.save();
    }
    return _node;
}

Rkns.Project.prototype.addEdge = function(_props, _render_save) {
    var _edge = new Rkns.Model.Edge(this, _props);
    this.edges.push(_edge);
    if (typeof _render_save !== "undefined" && (_render_save&Rkns._RENDER)) {
        var _controller = this.renderer.addController("Edge", _edge);
        _controller.redraw();
    }
    if (typeof _render_save !== "undefined" && (_render_save&Rkns._SAVE)) {
        this.serializer.save();
    }
    return _edge;
}

Rkns.Project.prototype.addUser = function(_props, _render_save) {
    var _user = new Rkns.Model.User(this, _props);
    this.users.push(_user);
    return _user;
}

Rkns.Project.prototype.updateElement = function(_element, _props, _render_save) {
    Rkns._(_props).each(function(_v, _k) {
        _element[_k] = _v;
    });
    if (typeof _render_save !== "undefined" && (_render_save&Rkns._RENDER)) {
        if (typeof _element.__controller !== "undefined") {
            _element.__controller.redraw();
        } else {
            this._renderer.redraw();
        }
    }
    if (typeof _render_save !== "undefined" && (_render_save&Rkns._SAVE)) {
        this.serializer.save();
    }
}

Rkns.Project.prototype.removeNode = function(_node, _render_save) {
    this.nodes.removeId(_node.id);
    if (typeof _node.__controller !== "undefined") {
        console.log("Controllers", this.renderer.controllers.length);
        this.renderer.removeController(_node.__controller);
        console.log("Controllers", this.renderer.controllers.length);
    }
    console.log(this.edges.length);
    var _this = this;
    this.edges = this.edges.filter(function(_edge) {
        var _keep = _edge.from !== _node && _edge.to !== _node;
        if (!_keep && typeof _edge.__controller !== "undefined") {
            _this.renderer.removeController(_edge.__controller);
        }
        return _keep;
    });
    if (typeof _render_save !== "undefined" && (_render_save&Rkns._RENDER)) {
        this.renderer.redraw();
    }
    if (typeof _render_save !== "undefined" && (_render_save&Rkns._SAVE)) {
        this.serializer.save();
    }
    return _node;
}

/* Utility functions */

Rkns.Utils = {
    _ID_AUTO_INCREMENT : 0,
    _ID_BASE : (function(_d) {
        function pad(n){return n<10 ? '0'+n : n}
        function fillrand(n) {
            var _res = ''
            for (var i=0; i<n; i++) {
                _res += Math.floor(16*Math.random()).toString(16);
            }
            return _res;
        }
        return _d.getUTCFullYear() + '-'  
            + pad(_d.getUTCMonth()+1) + '-'  
            + pad(_d.getUTCDate()) + '-'
            + fillrand(16);
    })(new Date()),
    getUID : function(_base) {
        var _n = (++this._ID_AUTO_INCREMENT).toString(16),
            _base = (typeof _base === "undefined" ? "" : _base + "-" );
        while (_n.length < 4) {
            _n = '0' + _n
        }
        return _base + this._ID_BASE + '-' + _n;
    },
    inherit : function(_baseClass, _callbefore) {
        var _class = function() {
            if (typeof _callbefore === "function") {
                _callbefore.apply(this, Array.prototype.slice.call(arguments, 0));
            }
            if (typeof _baseClass.prototype._init !== "function") {
                _baseClass.prototype._init = function() {}
            }
            _baseClass.apply(this, Array.prototype.slice.call(arguments, 0));
            this._init.apply(this, Array.prototype.slice.call(arguments, 0));
        }
        _class.prototype = new _baseClass();
        return _class;
    }
}