/*
 * Decompiled with CFR 0.152.
 */
package org.coweb.oe;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.coweb.oe.ContextVector;
import org.coweb.oe.DeleteOperation;
import org.coweb.oe.InsertOperation;
import org.coweb.oe.OperationEngineException;
import org.coweb.oe.UpdateOperation;

public abstract class Operation {
    protected static final int infinity = 99999999;
    protected int siteId;
    protected int seqId;
    protected String type = null;
    protected boolean local = false;
    protected ContextVector contextVector = null;
    protected String key = null;
    protected String value = null;
    protected int position;
    protected int order;
    protected boolean immutable;
    protected Vector<Operation> xCache = null;

    public static Operation createOperationFromType(String type, Map<String, Object> args) throws OperationEngineException {
        Operation op = null;
        if (type.equals("insert")) {
            op = new InsertOperation(args);
        } else if (type.equals("delete")) {
            op = new DeleteOperation(args);
        } else if (type.equals("update")) {
            op = new UpdateOperation(args);
        }
        return op;
    }

    public static Operation createOperationFromState(Object[] state) throws OperationEngineException {
        return null;
    }

    public static String createHistoryKey(int site, int seq) {
        return new Integer(site).toString() + "," + new Integer(seq).toString();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("{siteId : " + this.siteId);
        b.append(",seqId : " + this.seqId);
        b.append(",type :" + this.type);
        b.append(",contextVector : " + this.contextVector);
        b.append(",key : " + this.key);
        b.append(",position : " + this.position);
        b.append(",order : " + this.order);
        b.append("}");
        return b.toString();
    }

    protected Operation(Map<String, Object> args) throws OperationEngineException {
        if (args == null) {
            this.type = null;
            return;
        }
        if (args.containsKey("state")) {
            this.setState((Object[])args.get("state"));
            this.local = false;
        } else {
            this.siteId = (Integer)args.get("siteId");
            this.contextVector = (ContextVector)args.get("contextVector");
            this.key = (String)args.get("key");
            this.value = (String)args.get("value");
            this.position = (Integer)args.get("position");
            Integer ord = (Integer)args.get("order");
            this.order = ord == null ? 99999999 : ord;
            if (args.containsKey("seqId")) {
                this.seqId = (Integer)args.get("seqId");
            } else if (this.contextVector != null) {
                this.seqId = this.contextVector.getSeqForSite(this.siteId) + 1;
            } else {
                throw new OperationEngineException("missing sequence id for new operation");
            }
            this.xCache = args.containsKey("xCache") ? (Vector)args.get("xCache") : null;
            this.local = ((Boolean)args.get("local")).booleanValue();
        }
        this.immutable = false;
        if (this.xCache == null) {
            this.xCache = new Vector();
        }
    }

    public abstract Operation transformWithDelete(Operation var1);

    public abstract Operation transformWithInsert(Operation var1);

    public abstract Operation transformWithUpdate(Operation var1);

    public Object[] getState() {
        Object[] arr = new Object[]{this.type, this.key, this.value, this.position, this.contextVector.getSites(), this.seqId, this.siteId, this.order};
        return arr;
    }

    public void setState(Object[] arr) throws OperationEngineException {
        if (!((String)arr[0]).equals(this.type)) {
            throw new OperationEngineException("setState invoked with state from wrong op type");
        }
        if (this.immutable) {
            throw new OperationEngineException("op is immutable");
        }
        this.key = (String)arr[1];
        this.value = (String)arr[2];
        this.position = (Integer)arr[3];
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("state", (Object[])arr[4]);
        this.contextVector = new ContextVector(args);
        this.seqId = (Integer)arr[5];
        this.siteId = (Integer)arr[6];
        this.order = arr.length >= 8 ? (Integer)arr[7] : 99999999;
    }

    public Operation copy() throws OperationEngineException {
        Operation op;
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("siteId", new Integer(this.siteId));
        args.put("seqId", new Integer(this.seqId));
        args.put("contextVector", this.contextVector.copy());
        args.put("key", this.key);
        args.put("value", this.value);
        args.put("position", new Integer(this.position));
        args.put("order", new Integer(this.order));
        args.put("local", new Boolean(this.local));
        args.put("xCache", this.xCache);
        try {
            op = Operation.createOperationFromType(this.type, args);
        }
        catch (OperationEngineException e) {
            e.printStackTrace();
            op = null;
        }
        return op;
    }

    public Operation getFromCache(ContextVector cv) throws OperationEngineException {
        Vector<Operation> cache = this.xCache;
        int l = cache.size();
        for (int i = 0; i < l; ++i) {
            Operation xop = cache.elementAt(i);
            if (!xop.contextVector.equals(cv)) continue;
            return xop.copy();
        }
        return null;
    }

    public void addToCache(int siteCount) throws OperationEngineException {
        Vector<Operation> cache = this.xCache;
        Operation cop = this.copy();
        cop.immutable = true;
        cache.addElement(cop);
        int diff = cache.size() - (siteCount - 1);
        if (diff > 0) {
            Operation[] arr = new Operation[cache.size()];
            arr = cache.toArray(arr);
            Operation[] newArr = Arrays.copyOf(arr, diff);
            cache.removeAllElements();
            for (int i = 0; i < newArr.length; ++i) {
                cache.addElement(newArr[i]);
            }
        }
    }

    public int compareByContext(Operation op) {
        int rv = this.contextVector.compare(op.contextVector);
        if (rv == 0) {
            if (this.siteId < op.siteId) {
                return -1;
            }
            if (this.siteId > op.siteId) {
                return 1;
            }
            return 0;
        }
        return rv;
    }

    public int compareByOrder(Operation op) {
        if (this.order == op.order) {
            if (this.local == op.local) {
                return this.seqId < op.seqId ? -1 : 1;
            }
            if (this.local && !op.local) {
                return 1;
            }
            if (!this.local && op.local) {
                return -1;
            }
        } else {
            if (this.order < op.order) {
                return -1;
            }
            if (this.order > op.order) {
                return 1;
            }
        }
        return -1;
    }

    public Operation transformWith(Operation op) throws OperationEngineException {
        if (this.immutable) {
            throw new OperationEngineException("attempt to transform immutable op");
        }
        Operation rv = null;
        if (op.type.equals("delete")) {
            rv = this.transformWithDelete(op);
        } else if (op.type.equals("insert")) {
            rv = this.transformWithInsert(op);
        } else if (op.type.equals("update")) {
            rv = this.transformWithUpdate(op);
        }
        if (rv != null) {
            this.upgradeContextTo(op);
        }
        return rv;
    }

    public void upgradeContextTo(Operation op) throws OperationEngineException {
        if (this.immutable) {
            throw new OperationEngineException("attempt to upgrade context of immutable op");
        }
        this.contextVector.setSeqForSite(op.siteId, op.seqId);
    }

    public int getSiteId() {
        return this.siteId;
    }

    public int getSeqId() {
        return this.seqId;
    }

    public String getValue() {
        return this.value;
    }

    public int getPosition() {
        return this.position;
    }

    public ContextVector getContextVector() {
        return this.contextVector;
    }

    public void setImmutable(boolean immutable) {
        this.immutable = immutable;
    }
}

