<?php

    require_once(realpath(dirname(__FILE__) . "/../resources/config.php"));

    require_once(LIBRARY_PATH . "/templateFunctions.php");
    require_once(LIBRARY_PATH . "/utilsFunctions.php");
    require_once(LIBRARY_PATH . "/renkanFunctions.php");
    require_once(LIBRARY_PATH . "/dbFunctions.php");

    $self_url = selfURL();
    $index_url = selfBaseURL().'/index.php';

    if ($_SERVER['REQUEST_METHOD'] === 'PUT' || $_SERVER['REQUEST_METHOD'] === 'POST') {

        //TODO implement CSRF with https://github.com/BKcore/NoCSRF for example
        $renkanId = isset($_POST['renkanId']) ? $_POST['renkanId'] : false;

        if(!empty($renkanId)) {
            deleteProject($renkanId);
        }
        header("Location: $index_url");
        die();
    }

    if(!isset($_GET['renkanId'])) {
        header("Location: $index_url");
        die();
    }
    $renkanId = $_GET['renkanId'];
    $resRenkan = selectProject($renkanId);

    if(count($resRenkan) === 0) {
        header("Location: $index_url");
        die();
    }

    $variables = [ 'renkan' => $resRenkan[0], 'self_url' => selfURL(), 'self_base_url' => selfBaseURL()];
    $css = [];

    renderLayoutWithContentFile("renkan_del.php", $variables, $css);
