package org.iri_research.renkan.models;

import java.util.Collection;
import java.util.Date;

import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import com.fasterxml.jackson.annotation.JsonIgnore;

@Document(collection="users")
public class User extends AbstractRenkanModel<String> implements UserDetails {
	
	private static final long serialVersionUID = 6972038893086220548L;
	
	private String email;
	private String password;
	private String salt;
	private String avatar;
	private boolean enabled;
	private boolean locked;
	
	@Field("expiration_date")
	private Date expirationDate;
	
	@Field("credentials_expiration_date")
	private Date credentialExpirationDate;

	public User(String id, String title, String description, String uri, String color) {
		super(id, title, description, uri, color);
	}	
	
	public String getColor() {
		return this.color;
	}

	@Override
	public Collection<? extends GrantedAuthority> getAuthorities() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	@JsonIgnore
	public String getPassword() {
		return this.password;
	}

	@Override
	@JsonIgnore
	public String getUsername() {
		return this.title;
	}

	@Override
	public boolean isAccountNonExpired() {
		return this.expirationDate == null || this.expirationDate.after(new Date());
	}

	@Override
	public boolean isAccountNonLocked() {
		return !this.locked;
	}

	@Override
	public boolean isCredentialsNonExpired() {
		return this.credentialExpirationDate == null || this.credentialExpirationDate.after(new Date());
	}

	@Override
	public boolean isEnabled() {
		return this.enabled;
	}

	public String getEmail() {
		return email;
	}

	public String getAvatar() {
		return avatar;
	}
	
}
