/* Saves the Full JSON once */

Rkns.jsonIOSaveOnClick = function(_renkan, _opts) {
    var _proj = _renkan.project,
        _saveWarn = false,
        _onLeave = function() {
            return "Project not saved";
        };
    if (typeof _opts.http_method === "undefined") {
        _opts.http_method = 'POST';
    }
    var _load = function() {
        var getdata = {},
            rx = /id=([^&#?=]+)/,
            matches = document.location.hash.match(rx);
        if (matches) {
            getdata.id = matches[1];
        }
        Rkns.$.ajax({
            url: _opts.url,
            data: getdata,
            beforeSend: function(){
                _proj.set({loading_status:true});
            },
            success: function(_data) {
                _proj.set(_data, {validate: true});
                _proj.set({loading_status:false});
                _proj.set({save_status:0});
                _renkan.renderer.autoScale();
            }
        });
    };
    var _save = function() {
        _proj.set("saved_at", new Date());
        var _data = _proj.toJSON();
        Rkns.$.ajax({
            type: _opts.http_method,
            url: _opts.url,
            contentType: "application/json",
            data: JSON.stringify(_data),
            beforeSend: function(){
                _proj.set({save_status:2});
            },
            success: function(data, textStatus, jqXHR) {
                $(window).off("beforeunload", _onLeave);
                _saveWarn = false;
                _proj.set({save_status:0});
                //document.location.hash = "#id=" + data.id;
                //$(".Rk-Notifications").text("Saved as "+document.location.href).fadeIn().delay(2000).fadeOut();
            }
        });
    };
    var _checkLeave = function() {
        _proj.set({save_status:1});
        
        var title = _proj.get("title");
        if (title && _proj.get("nodes").length) {
            $(".Rk-Save-Button").removeClass("disabled");
        } else {
            $(".Rk-Save-Button").addClass("disabled");
        }
        if (title) {
            $(".Rk-PadTitle").css("border-color","#333333");
        }
        if (!_saveWarn) {
            _saveWarn = true;
            $(window).on("beforeunload", _onLeave);
        }
    };
    _load();
    _proj.on("add:nodes add:edges add:users change", function(_model) {
        _model.on("change remove", function(_model) {
            if(!(_model.changedAttributes.length === 1 && _model.hasChanged('save_status'))) {
                _checkLeave();
            }
        });
        if(!(_proj.changedAttributes.length === 1 && _proj.hasChanged('save_status'))) {
            _checkLeave();
        }
    });
    _renkan.renderer.save = function() {
        if ($(".Rk-Save-Button").hasClass("disabled")) {
            if (!_proj.get("title")) {
                $(".Rk-PadTitle").css("border-color","#ff0000");
            }
        } else {
            _save();
        }
    };
};
