package org.iri_research.renkan.models;

import com.fasterxml.jackson.annotation.JsonProperty;

public class RosterUser extends AbstractRenkanModel<String> {
	
	private String projectId;
	private Long siteId;
	private String clientId;

	public RosterUser(String id, String title, String description, String uri, String color, String project_id, Long site_id, String client_id) {
		super(id, title, description, uri, color);
		
		this.projectId = project_id;
		this.siteId = site_id;
		this.clientId = client_id;
	}
	
	public void setTitle(String title) {
		this.title = title;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	
	public void setUri(String uri) {
		this.uri = uri;
	}
		
	public void setColor(String color) {
		this.color = color;
	}	

	@JsonProperty(value="project_id")
	public String getProjectId() {
		return projectId;
	}

	@JsonProperty(value="site_id")
	public Long getSiteId() {
		return siteId;
	}
	
	@JsonProperty(value="client_id")
	public String getClientId() {
		return clientId;
	}

	
}
