package org.iri_research.renkan.models;

import org.springframework.data.mongodb.core.mapping.Field;


public class RenkanUser {
	
	@Field(value="user_id")
	private String userId;
	private String color;
	private String username;
	
		
	@SuppressWarnings("unused")
	private RenkanUser() {
	}
	
	public RenkanUser(String projectId, String userId, String color,
			String username) {
		this.userId = userId;
		this.color = color;
		this.username = username;
	}

	public RenkanUser(RenkanUser user) {
		if(user !=  null) {
			this.setUserId(user.getUserId());
			this.setColor(user.getColor());
			this.setUsername(user.getUsername());
		}
	}
	
	@Field(value="user_id")
	public String getUserId() {
		return userId;
	}
	
	@Field(value="user_id")
	public void setUserId(String userId) {
		this.userId = userId;
	}
	
	public String getColor() {
		return color;
	}
	
	public void setColor(String color) {
		this.color = color;
	}
	
	public String getUsername() {
		return username;
	}
	
	public void setUsername(String username) {
		this.username = username;
	}
	
	public boolean isAnonymous() {
		return this.getUserId() == null;
	}

}
