package org.iri_research.renkan.coweb;

import javax.inject.Inject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
//@Scope("prototype")
public class SpringConfigurer implements ApplicationContextAware
{
	
    //private BayeuxServer bayeuxServer;
    //private ServerAnnotationProcessor processor;
    private final Logger logger = LoggerFactory.getLogger(SpringConfigurer.class);
    private ApplicationContext context;
    
    private static volatile SpringConfigurer instance = null;
        
    private SpringConfigurer() 
    {
    	this.logger.debug("Building SpringConfigurer");    	
    }
    
    public static SpringConfigurer getInstance() {
    	if (instance == null) {
    		synchronized (SpringConfigurer.class) {
				if(instance == null) {
					instance = new SpringConfigurer();
				}
			}
    	}
    	return instance;
    }


    
	@Override
	@Inject
	public void setApplicationContext(ApplicationContext context)
			throws BeansException {
		this.context = context;
	}
	
	public ApplicationContext getApplicationContext() {
		return this.context;
	}
}