# -*- coding: utf-8 -*-
# Generated by Django 1.9.1 on 2016-04-14 12:23
from __future__ import unicode_literals

from django.db import migrations


def populate_foreign_keys(apps, schema_editor):
    renkans = apps.get_model('renkanmanager', 'Renkan')
    revisions = apps.get_model('renkanmanager', 'Revision')
    workspaces = apps.get_model('renkanmanager', 'Workspace')
    for renkan in renkans.objects.all():
        current_revision_for_renkan = revisions.objects.get(revision_guid=renkan.current_revision_guid)
        renkan.current_revision = current_revision_for_renkan
        if renkan.source_revision_guid:
            current_source_for_renkan = revisions.objects.get(revision_guid=renkan.source_revision_guid)
            renkan.source_revision = current_source_for_renkan
        if renkan.workspace_guid:
            workspace_for_renkan = revisions.objects.get(revision_guid=renkan.workspace_guid)
            renkan.workspace = workspace_for_renkan
        renkan.save()
    for revision in revisions.objects.all():
        parent_renkan_for_revision = renkans.objects.get(renkan_guid=revision.parent_renkan_guid)
        revision.parent_renkan = parent_renkan_for_revision
        revision.save()
            

class Migration(migrations.Migration):

    dependencies = [
        ('renkanmanager', '0004_foreign_key_fields_initial'),
    ]

    operations = [
        migrations.RunPython(populate_foreign_keys)
    ]
